/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTUtils2 {
    public static <T> List<T> deserializeList(@NotNull CompoundTag tag, @NotNull String key, Function<CompoundTag, T> func) {
        ListTag listTag = tag.m_128437_(key, 10);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < listTag.size(); ++i) {
            list.add(func.apply(listTag.m_128728_(i)));
        }
        return list;
    }

    public static <T> ListTag serializeList(@NotNull CompoundTag tag, @NotNull String key, @NotNull List<T> list, @NotNull Function<T, CompoundTag> func) {
        ListTag listTag = new ListTag();
        tag.m_128365_(key, (Tag)listTag);
        for (T element : list) {
            listTag.add((Object)((Tag)func.apply(element)));
        }
        return listTag;
    }

    public static CompoundTag getOrEmpty(@Nullable CompoundTag tag, @NotNull String key) {
        if (tag != null && tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        return new CompoundTag();
    }

    public static CompoundTag getOrCreate(@Nullable CompoundTag tag, @NotNull String key) {
        if (tag != null) {
            if (tag.m_128425_(key, 10)) {
                return tag.m_128469_(key);
            }
            CompoundTag child = new CompoundTag();
            tag.m_128365_(key, (Tag)child);
            return child;
        }
        return new CompoundTag();
    }

    private NBTUtils2() {
    }

    public static interface TagProvider {
        @NotNull
        public CompoundTag get(@Nullable CompoundTag var1, @NotNull String var2);
    }
}

