/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import steve_gall.minecolonies_compatibility.api.common.inventory.IRecipeTransferableMenu;
import steve_gall.minecolonies_compatibility.core.common.network.AbstractMessage;

public class JEIRecipeTransferMessage
extends AbstractMessage {
    private final RecipeType<?> type;
    private final ResourceLocation id;
    private final CompoundTag tag;

    public JEIRecipeTransferMessage(Recipe<?> recipe, CompoundTag tag) {
        this.type = recipe.m_6671_();
        this.id = recipe.m_6423_();
        this.tag = tag;
    }

    public JEIRecipeTransferMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.type = (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(buffer.m_130281_());
        this.id = buffer.m_130281_();
        this.tag = buffer.m_130260_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130085_(ForgeRegistries.RECIPE_TYPES.getKey(this.type));
        buffer.m_130085_(this.id);
        buffer.m_130079_(this.tag);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        player.m_9236_().m_7465_().m_44043_(this.id).ifPresent(recipe -> {
            AbstractContainerMenu patt1757$temp = player.f_36096_;
            if (patt1757$temp instanceof IRecipeTransferableMenu) {
                IRecipeTransferableMenu menu = (IRecipeTransferableMenu)patt1757$temp;
                menu.onRecipeTransfer(recipe, this.tag);
            }
        });
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundTag getTag() {
        return this.tag;
    }
}

