/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_compatibility.core.common.network.AbstractMessage;

public class JEIGhostAcceptMessage
extends AbstractMessage {
    private final int slotNumber;
    private final ItemStack stack;

    public JEIGhostAcceptMessage(int slotNumber, ItemStack stack) {
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public JEIGhostAcceptMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.slotNumber = buffer.readInt();
        this.stack = buffer.m_130267_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.slotNumber);
        buffer.m_130055_(this.stack);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu instanceof IItemGhostMenu) {
            IItemGhostMenu ghostMenu = (IItemGhostMenu)menu;
            Slot slot = menu.m_38853_(this.slotNumber);
            ghostMenu.onGhostAccept(slot, this.stack);
        }
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

