/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackHelper {
    public static List<ItemStack> getCraftingRemainings(List<ItemStack> list) {
        ArrayList<ItemStack> craftingRemainings = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            ItemStack craftingRemaining = stack.getCraftingRemainingItem();
            if (craftingRemaining.m_41619_()) continue;
            craftingRemainings.add(craftingRemaining);
        }
        return craftingRemainings;
    }

    public static boolean isTool(@NotNull ItemStack stack, @NotNull IToolType toolType) {
        return ItemStackUtils.isTool((ItemStack)stack, (IToolType)toolType);
    }

    public static boolean isTool(@NotNull List<ItemStack> list, @NotNull IToolType toolType) {
        return list.stream().allMatch(stack -> ItemStackHelper.isTool(stack, toolType));
    }

    public static boolean equals(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.equalsIgnoreSize(stack1, stack2) && stack1.m_41613_() == stack2.m_41613_();
    }

    public static boolean equalsIgnoreSize(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)stack1, (ItemStack)stack2);
    }

    private ItemStackHelper() {
    }
}

