/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;

public class ItemHandlerHelper2 {
    public static IItemHandlerModifiable wrap(List<ItemStack> list) {
        ItemStackHandler handler = new ItemStackHandler(list.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, list.get(i));
        }
        return handler;
    }

    public static List<ItemStack> unwrap(IItemHandler handler, boolean empty) {
        int slots = handler.getSlots();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!empty && stack.m_41619_()) continue;
            list.add(stack);
        }
        return list;
    }

    public static boolean move(IItemHandler from, IItemHandlerModifiable to, int toIndexStart, List<ItemStorage> storages) {
        for (int storageIndex = 0; storageIndex < storages.size(); ++storageIndex) {
            ItemStorage storage = storages.get(storageIndex);
            boolean inserted = false;
            for (int fromSlot = 0; fromSlot < from.getSlots(); ++fromSlot) {
                if (!to.getStackInSlot(toIndexStart + storageIndex).m_41619_()) {
                    return false;
                }
                ItemStack extracting = from.extractItem(fromSlot, storage.getAmount(), true);
                if (!ItemStorageHelper.matches(storage, extracting, true)) continue;
                to.setStackInSlot(toIndexStart + storageIndex, extracting.m_41777_());
                from.extractItem(fromSlot, storage.getAmount(), false);
                inserted = true;
                break;
            }
            if (inserted) continue;
            return false;
        }
        return true;
    }

    private ItemHandlerHelper2() {
    }
}

