/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import steve_gall.minecolonies_compatibility.api.common.inventory.IItemGhostMenu;
import steve_gall.minecolonies_compatibility.api.common.inventory.IRecipeTransferableMenu;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuNewResultMessage;

public abstract class TeachRecipeMenu<RECIPE extends Recipe<CONTAINER>, CONTAINER extends Container>
extends ModuleMenu
implements IItemGhostMenu,
IRecipeTransferableMenu<RECIPE> {
    protected CraftingContainer craftMatrix;
    protected List<Slot> craftSlots;
    protected Container resultContainer;
    protected List<Slot> resultSlots;
    protected RECIPE recipe;

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, BlockPos buildingId, int moduleId) {
        super(menuType, windowId, inventory, buildingId, moduleId);
        this.setup();
    }

    public TeachRecipeMenu(MenuType<?> menuType, int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.craftSlots = new ArrayList<Slot>();
        this.resultSlots = new ArrayList<Slot>();
        this.craftMatrix = null;
        this.resultContainer = null;
        this.recipe = null;
    }

    public abstract RecipeType<RECIPE> getRecipeType();

    public abstract CraftingType getCraftingType();

    protected abstract void onSetRecipe(RECIPE var1);

    protected abstract CONTAINER createRecipeContainer(CraftingContainer var1);

    @Override
    public void onRecipeTransfer(RECIPE recipe, CompoundTag tag) {
        for (Slot slot : this.craftSlots) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        this.setRecipe(recipe);
    }

    @Override
    public void onGhostAccept(Slot slot, ItemStack stack) {
        if (this.craftSlots.contains(slot)) {
            slot.m_5852_(stack);
            this.m_6199_((Container)this.craftMatrix);
        }
    }

    public void m_6199_(Container container) {
        Player player = this.inventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (container == this.craftMatrix) {
                Level level = player2.m_9236_();
                CONTAINER recipeContainer = this.createRecipeContainer(this.craftMatrix);
                Recipe recipe = level.m_7465_().m_44015_(this.getRecipeType(), recipeContainer, level).orElse(null);
                if (recipe != null) {
                    boolean canLearn = recipe.m_5598_() || !level.m_46469_().m_46207_(GameRules.f_46151_) || player2.m_8952_().m_12709_(recipe) || player2.m_7500_();
                    this.setRecipe(canLearn ? recipe : null);
                } else {
                    this.setRecipe(null);
                }
            } else if (container == this.resultContainer) {
                ResourceLocation recipeId = this.recipe != null ? this.recipe.m_6423_() : null;
                MineColoniesCompatibility.network().sendToPlayer(new TeachRecipeMenuNewResultMessage(recipeId), player2);
            }
        }
        super.m_6199_(container);
    }

    public void setRecipeId(ResourceLocation recipeId) {
        this.setRecipe(this.inventory.f_35978_.m_9236_().m_7465_().m_44043_(recipeId).orElse(null));
    }

    public void setRecipe(RECIPE recipe) {
        RECIPE prev = this.recipe;
        this.onSetRecipe(recipe);
        RECIPE next = this.recipe;
        if (prev != next) {
            this.m_6199_(this.resultContainer);
        }
    }

    public void m_150399_(int slotNumber, int clickedButton, ClickType mode, Player player) {
        if (0 <= slotNumber && slotNumber < this.f_38839_.size()) {
            Slot slot = (Slot)this.f_38839_.get(slotNumber);
            if (this.craftSlots.contains(slot)) {
                if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                    this.handleSlotClick(slot, this.m_142621_());
                }
                return;
            }
            if (this.resultSlots.contains(slot)) {
                return;
            }
            if (mode == ClickType.QUICK_MOVE) {
                return;
            }
        }
        super.m_150399_(slotNumber, clickedButton, mode, player);
    }

    public ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slot.m_5852_(copy);
        } else if (slot.m_7993_().m_41613_() > 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return slot.m_7993_().m_41777_();
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return !this.resultSlots.contains(slot) && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public CraftingContainer getCraftMatrix() {
        return this.craftMatrix;
    }

    public List<Slot> getCraftSlots() {
        return Collections.unmodifiableList(this.craftSlots);
    }

    public Container getResultContainer() {
        return this.resultContainer;
    }

    public List<Slot> getResultSlots() {
        return Collections.unmodifiableList(this.resultSlots);
    }

    public RECIPE getRecipe() {
        return this.recipe;
    }
}

