/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.pathfinding;

import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist.Fruit;
import steve_gall.minecolonies_compatibility.core.common.entity.pathfinding.FruitPathResult;
import steve_gall.minecolonies_tweaks.api.common.pathfinding.SimplePathJob;

public class PathJobFindFruit
extends SimplePathJob<FruitPathResult> {
    public int vertialRange = 10;
    public boolean needHarvestable = true;
    public boolean needMaxHarvest = true;
    public final Set<ResourceLocation> exceptFruits = new HashSet<ResourceLocation>();

    public PathJobFindFruit(@NotNull Level level, @NotNull BlockPos start, @NotNull BlockPos home, int range, @Nullable Mob entity) {
        super(level, start, home, range, entity, (PathResult)new FruitPathResult());
    }

    public PathJobFindFruit(@NotNull Level level, @NotNull BlockPos start, @NotNull BoundingBox restrictionBox, @Nullable Mob entity) {
        super(level, start, restrictionBox, entity, (PathResult)new FruitPathResult());
    }

    protected boolean testTarget(int x, int y, int z) {
        for (int i = 0; i <= this.vertialRange; ++i) {
            if (!this.findFruitAt(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    private boolean findFruitAt(int x, int y, int z) {
        Fruit fruit = new Fruit(new BlockPos(x, y, z));
        if (this.test(fruit)) {
            ((FruitPathResult)this.getResult()).fruit = fruit;
            return true;
        }
        return false;
    }

    private boolean test(Fruit fruit) {
        if (!fruit.updateAndIsValid(this.world)) {
            return false;
        }
        if (this.exceptFruits.contains(fruit.getFruit().getId())) {
            return false;
        }
        if (this.needHarvestable) {
            return fruit.canHarvest(this.needMaxHarvest);
        }
        return fruit.getContext().getState().m_60734_() instanceof BonemealableBlock;
    }
}

