/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.guard;

import net.minecraftforge.common.ForgeConfigSpec;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackRangeConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.MoveSpeedConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.SearchRangeConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;

public class GunnerConfig {
    public final ForgeConfigSpec.EnumValue<BulletMode> bulletMode;
    public final SearchRangeConfig searchRange;
    public final AttackRangeConfig attackRange;
    public final MoveSpeedConfig combatMoveSpeed;

    public GunnerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{BulletMode.DONT_USE.name() + ": don't use bullet, only shot default bullet", BulletMode.CAN_USE.name() + ": use bullet if citizen have bullet, else shot default bullet", BulletMode.ONLY_USE.name() + ": citizen must have bullet"});
        this.bulletMode = builder.defineEnum("bulletMode", (Enum)BulletMode.CAN_USE);
        builder.push("searchRange");
        this.searchRange = new SearchRangeConfig(builder, 25);
        builder.pop();
        builder.push("attackRange");
        this.attackRange = new AttackRangeConfig(builder, new AttackRangeConfig.DefaultValues().base(10.0).increasePerSkillLevel(0.3).increasePerBuildingLevel(1.0).maximum(24.0).bonusOnGuard(10.0).yDifferenceCorrection(true));
        builder.pop();
        builder.push("combatMoveSpeed");
        this.combatMoveSpeed = new MoveSpeedConfig(builder, new MoveSpeedConfig.DefaultValues().base(1.0).increasePerSkillLevel(0.01).increasePerBuildingLevel(0.02));
        builder.pop();
    }
}

