/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.colony;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.function.Predicate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CitizenHelper {
    public static int getMaxLevelToolSlot(@NotNull ICitizenData citizen, @NotNull IToolType toolType) {
        InventoryCitizen inventory = citizen.getInventory();
        int maxToolLevel = citizen.getWorkBuilding().getMaxToolLevel();
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)inventory, (IToolType)toolType, (int)0, (int)maxToolLevel);
    }

    public static JobEntry getJobEntry(@NotNull ICitizenData citizen) {
        IJob job = citizen.getJob();
        return job != null ? job.getJobRegistryEntry() : null;
    }

    public static <R> boolean isRequested(@NotNull ICitizenData citizen, @NotNull TypeToken<R> token, @NotNull Predicate<IRequest<? extends R>> predicate) {
        IBuilding building = citizen.getWorkBuilding();
        if (!building.getOpenRequestsOfTypeFiltered(citizen, token, predicate).isEmpty()) {
            return true;
        }
        return !building.getCompletedRequestsOfTypeFiltered(citizen, token, predicate).isEmpty();
    }

    private CitizenHelper() {
    }
}

