/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;
import steve_gall.minecolonies_tweaks.core.client.gui.CloseableWindowExtension;
import steve_gall.minecolonies_tweaks.core.common.config.MineColoniesTweaksConfigClient;

public abstract class TeachRecipeScreen<MENU extends TeachRecipeMenu<RECIPE, ?>, RECIPE extends Recipe<?>>
extends AbstractContainerScreen<MENU>
implements CloseableWindowExtension {
    protected final IBuildingView building;
    protected final CraftingModuleView module;
    private Button doneButton;
    private Button closeButton;
    private Screen parent;

    public TeachRecipeScreen(MENU menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.building = IMinecoloniesAPI.getInstance().getColonyManager().getBuildingView(inventory.f_35978_.m_9236_().m_46472_(), ((ModuleMenu)((Object)menu)).getBuildingId());
        this.module = (CraftingModuleView)this.building.getModuleView(((ModuleMenu)((Object)menu)).getModuleId());
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean canLearn = this.module.canLearn(((TeachRecipeMenu)this.f_97732_).getCraftingType());
        MutableComponent text = Component.m_237115_((String)(canLearn ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"));
        this.doneButton = Button.m_253074_((Component)text, this::onDoneButtonPress).m_252987_(this.f_97735_ + 1, this.f_97736_ + this.f_97727_ + 4, 150, 20).m_253136_();
        this.doneButton.f_93623_ = canLearn && ((TeachRecipeMenu)this.f_97732_).getRecipe() != null;
        this.m_142416_((GuiEventListener)this.doneButton);
        if (((Boolean)MineColoniesTweaksConfigClient.INSTANCE.addReturnButton.get()).booleanValue()) {
            this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), this::onClosePress).m_252987_(this.doneButton.m_252754_() + this.doneButton.m_5711_() + 5, this.doneButton.m_252907_(), this.doneButton.m_93694_(), this.doneButton.m_93694_()).m_253136_();
            this.m_142416_((GuiEventListener)this.closeButton);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        boolean canLearn = this.module.canLearn(((TeachRecipeMenu)this.f_97732_).getCraftingType());
        this.doneButton.f_93623_ = canLearn && ((TeachRecipeMenu)this.f_97732_).getRecipe() != null;
    }

    private void onDoneButtonPress(Button button) {
        Object recipe = ((TeachRecipeMenu)this.f_97732_).getRecipe();
        if (recipe != null) {
            List<ItemStorage> input = ItemHandlerHelper2.unwrap((IItemHandler)new InvWrapper((Container)((TeachRecipeMenu)this.f_97732_).getCraftMatrix()), false).stream().map(ItemStorage::new).toList();
            IRecipeStorage storage = this.createRecipeStorage(recipe, input).wrap();
            Network.getNetwork().sendToServer((IMessage)new AddRemoveRecipeMessage(this.building, false, storage, this.module.getProducer().getRuntimeID()));
        }
    }

    protected abstract ICustomizedRecipeStorage createRecipeStorage(RECIPE var1, List<ItemStorage> var2);

    private void onClosePress(Button button) {
        this.minecolonies_tweaks$returnOrClose();
    }

    public void minecolonies_tweaks$setParent(Screen screen) {
        this.parent = screen;
    }

    public Screen minecolonies_tweaks$getParent() {
        return this.parent;
    }

    public IBuildingView getBuilding() {
        return this.building;
    }

    public CraftingModuleView getModule() {
        return this.module;
    }
}

