/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantPositonContext;

public class PlantBlockContext
extends PlantPositonContext {
    @NotNull
    private final BlockState state;

    public PlantBlockContext(@NotNull LevelReader level, @NotNull BlockPos position, @NotNull BlockState state) {
        super(level, position);
        this.state = state;
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable HarvesterContext harvester) {
        LivingEntity entity = null;
        ItemStack tool = ItemStack.f_41583_;
        if (harvester != null) {
            entity = harvester.getEntity();
            tool = harvester.getTool();
        }
        return this.getDrops(entity, tool);
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable LivingEntity entity, @NotNull ItemStack tool) {
        LevelReader levelReader = this.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = this.getState();
            BlockPos position = this.getPosition();
            return Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)position, null, (Entity)entity, (ItemStack)tool);
        }
        return Collections.emptyList();
    }

    @NotNull
    public BlockState getState() {
        return this.state;
    }
}

