/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public abstract class CustomizedFruit {
    private static final Map<ResourceLocation, CustomizedFruit> REGISTRY = new HashMap<ResourceLocation, CustomizedFruit>();

    public static void register(@NotNull CustomizedFruit fruit) {
        REGISTRY.put(fruit.getId(), fruit);
    }

    public static Map<ResourceLocation, CustomizedFruit> getRegistry() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    @Nullable
    public static CustomizedFruit select(@NotNull PlantBlockContext context) {
        return REGISTRY.values().stream().filter(it -> it.test(context)).findFirst().orElse(null);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @NotNull
    public abstract ResourceLocation getId();

    @NotNull
    public abstract List<ItemStack> getBlockIcons();

    @NotNull
    public abstract List<ItemStack> getItemIcons();

    public abstract boolean test(@NotNull PlantBlockContext var1);

    public abstract boolean canHarvest(@NotNull PlantBlockContext var1);

    public abstract boolean isMaxHarvest(@NotNull PlantBlockContext var1);

    @NotNull
    public abstract List<ItemStack> harvest(@NotNull PlantBlockContext var1, @NotNull HarvesterContext var2);

    @NotNull
    public IToolType getHarvestToolType() {
        return ToolType.SHEARS;
    }

    @NotNull
    public IToolType getHarvestToolType(@NotNull PlantBlockContext context) {
        return this.getHarvestToolType();
    }

    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.f_12457_;
    }

    protected void replant(@NotNull PlantBlockContext context, @NotNull List<ItemStack> drops, BlockState replantState) {
        LevelReader levelReader;
        Block block = context.getState().m_60734_();
        boolean canReplant = false;
        for (int i = 0; i < drops.size(); ++i) {
            BlockItem item;
            ItemStack stack = drops.get(i);
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).m_40614_() != block) continue;
            canReplant = true;
            stack.m_41774_(1);
            if (!stack.m_41619_()) break;
            drops.remove(i);
            break;
        }
        if ((levelReader = context.getLevel()) instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.m_7731_(context.getPosition(), canReplant ? replantState : Blocks.f_50016_.m_49966_(), 2);
        }
    }
}

