/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.entity.ai.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGuard;
import steve_gall.minecolonies_compatibility.core.common.building.BuildingHelper;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.MoveSpeedConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.SearchRangeConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.GunnerConfig;
import steve_gall.minecolonies_compatibility.core.common.init.ModGuardTypes;
import steve_gall.minecolonies_compatibility.core.common.init.ModJobs;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public abstract class CustomizedAIGunner
extends CustomizedAIGuard {
    @Override
    @NotNull
    public GuardType getGuardType() {
        return (GuardType)ModGuardTypes.GUNNER.get();
    }

    public GunnerConfig getJobConfig() {
        return MineColoniesCompatibilityConfigServer.INSTANCE.jobs.gunner;
    }

    @Override
    public boolean test(@NotNull CustomizedAIContext context) {
        return CitizenHelper.getJobEntry(context.getUser().getCitizenData()) == ModJobs.GUNNER.get();
    }

    protected abstract boolean testAmmo(ItemStack var1);

    public int getAmmoSlot(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!this.testAmmo(inventory.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public void insertItem(@NotNull AbstractEntityCitizen user, @NotNull IItemHandler inventory, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        if (!result.m_41619_()) {
            BehaviorUtils.m_22613_((LivingEntity)user, (ItemStack)result.m_41777_(), (Vec3)user.m_20182_());
        }
    }

    public boolean requestAmmo(@NotNull AbstractEntityCitizen user, int minCount, boolean async) {
        ICitizenData citizen = user.getCitizenData();
        if (!CitizenHelper.isRequested(citizen, CustomizableDeliverable.TYPE_TOKEN, r -> this.isAmmoRequest(((CustomizableDeliverable)r.getRequest()).getObject()))) {
            citizen.getWorkBuilding().createRequest(citizen, (IRequestable)new CustomizableDeliverable(this.createAmmoRequest(minCount)), async);
            return true;
        }
        return false;
    }

    protected abstract IDeliverableObject createAmmoRequest(int var1);

    protected abstract boolean isAmmoRequest(IDeliverableObject var1);

    protected int getAmmoMinCount() {
        return 16;
    }

    public boolean takeAmmo(@Nullable AbstractEntityCitizen user) {
        ICitizenData citizen = user.getCitizenData();
        IBuilding building = citizen.getWorkBuilding();
        InventoryCitizen inventory = citizen.getInventory();
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((ICapabilityProvider)building, this::testAmmo, (int)64, (IItemHandler)inventory);
    }

    @Override
    public void atBuildingActions(@NotNull CustomizedAIContext context) {
        super.atBuildingActions(context);
        BulletMode bulletMode = (BulletMode)((Object)this.getJobConfig().bulletMode.get());
        if (bulletMode.canUse() && bulletMode.canDefault()) {
            AbstractEntityCitizen user = context.getUser();
            ICitizenData citizen = user.getCitizenData();
            this.takeAmmo(user);
            int minCount = this.getAmmoMinCount();
            int ammoCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), this::testAmmo);
            if (ammoCount < minCount) {
                this.requestAmmo(user, minCount, true);
            }
        }
    }

    public boolean checkAmmo(@NotNull AbstractEntityCitizen user) {
        BulletMode bulletMode = (BulletMode)((Object)this.getJobConfig().bulletMode.get());
        if (bulletMode.canUse() && this.isNeedRequestAmmo(user)) {
            boolean async = bulletMode.canDefault();
            this.requestAmmo(user, 16, async);
            return async;
        }
        return true;
    }

    protected boolean isNeedRequestAmmo(@NotNull AbstractEntityCitizen user) {
        return this.getAmmoSlot((IItemHandler)user.getInventoryCitizen()) == -1;
    }

    @Override
    public boolean canAttack(@NotNull CustomizedAIContext context, @NotNull LivingEntity target) {
        AbstractEntityCitizen user = context.getUser();
        if (!this.checkAmmo(user)) {
            return false;
        }
        return !this.isReloading(user) || this.onReloading(user);
    }

    @Override
    public int getAttackDelay(@NotNull CustomizedAIContext context, @NotNull LivingEntity target) {
        AbstractEntityCitizen user = context.getUser();
        return this.getAttackDealyConfig().apply(user, this.getSecondarySkillLevel(user));
    }

    protected abstract AttackDelayConfig getAttackDealyConfig();

    @Override
    public double getAttackDistance(@NotNull CustomizedAIContext context, @NotNull LivingEntity target) {
        GunnerConfig config = this.getJobConfig();
        AbstractEntityCitizen user = context.getUser();
        return config.attackRange.apply(user, this.getSecondarySkillLevel(user), target);
    }

    @Override
    public double getHorizontalSearchRange(@NotNull CustomizedAIContext context) {
        return ((Integer)this.getJobConfig().searchRange.horizontal.get()).doubleValue();
    }

    @Override
    public double getVerticalSearchRange(@NotNull CustomizedAIContext context) {
        SearchRangeConfig config = this.getJobConfig().searchRange;
        int range = (Integer)config.vertical.get();
        if (BuildingHelper.IsGuardsTask(context.getUser().getCitizenData().getWorkBuilding(), "com.minecolonies.core.guard.setting.guard")) {
            range += ((Integer)config.verticalBonusOnGuard.get()).intValue();
        }
        return range;
    }

    @Override
    public double getCombatMovementSpeed(@NotNull CustomizedAIContext context) {
        MoveSpeedConfig config = this.getJobConfig().combatMoveSpeed;
        AbstractEntityCitizen user = context.getUser();
        return config.apply(user, this.getPrimarySkillLevel(user));
    }

    public boolean reload(@NotNull AbstractEntityCitizen user) {
        if (!this.isReloading(user)) {
            this.startReload(user);
        }
        return this.onReloading(user);
    }

    protected boolean onReloading(@NotNull AbstractEntityCitizen user) {
        if (this.isReloadComplete(user)) {
            this.stopReload(user, true);
            return true;
        }
        return false;
    }

    protected void onReloadStarted(@NotNull AbstractEntityCitizen user) {
        user.m_6674_(InteractionHand.MAIN_HAND);
    }

    protected void onReloadStopped(@NotNull AbstractEntityCitizen user, boolean complete) {
        user.m_6674_(InteractionHand.MAIN_HAND);
    }

    protected int getReloadDuration() {
        return 0;
    }

    public boolean isReloadComplete(@NotNull AbstractEntityCitizen user) {
        int reloadDuration;
        long started;
        long current = user.m_9236_().m_46467_();
        return current >= (started = this.getOrEmptyTag(user).m_128454_("reloadStarted")) + (long)(reloadDuration = this.getReloadDuration());
    }

    public boolean isReloading(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128454_("reloadStarted") > 0L;
    }

    public void startReload(@NotNull AbstractEntityCitizen user) {
        this.getOrCreateTag(user).m_128356_("reloadStarted", user.m_9236_().m_46467_());
        this.onReloadStarted(user);
    }

    public void stopReload(@NotNull AbstractEntityCitizen user, boolean complete) {
        this.getOrCreateTag(user).m_128473_("reloadStarted");
        this.onReloadStopped(user, complete);
    }
}

