/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.entity.ai.guard;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingStatisticsModule;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.ai.combat.CombatUtils;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableAttackMoveAI;

public abstract class CustomizableAISimpleGuard<T extends AbstractEntityAIGuard<J, B>, J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AttackMoveAI<EntityCitizen>
implements ICustomizableAttackMoveAI<T, EntityCitizen> {
    @NotNull
    private final T parentAI;

    public CustomizableAISimpleGuard(EntityCitizen owner, ITickRateStateMachine<?> stateMachine, @NotNull T parentAI) {
        super((Mob)owner, stateMachine);
        this.parentAI = parentAI;
    }

    protected boolean skipSearch(LivingEntity entity) {
        AbstractJobGuard jobGuard;
        EntityCitizen citizen;
        IJob iJob;
        if (entity instanceof EntityCitizen && (iJob = (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob()) instanceof AbstractJobGuard && (jobGuard = (AbstractJobGuard)iJob).isAsleep() && ((EntityCitizen)this.user).m_21574_().m_148306_((Entity)citizen)) {
            this.getParentAI().setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    protected void onTargetDied(LivingEntity entity) {
        T parentAI = this.getParentAI();
        EntityCitizen user = (EntityCitizen)this.user;
        parentAI.incrementActionsDoneAndDecSaturation();
        user.getCitizenExperienceHandler().addExperience(15.0);
        user.getCitizenColonyHandler().getColony().getStatisticsManager().increment("mobs_killed", user.getCitizenColonyHandler().getColony().getDay());
        ComponentContents componentContents = entity.m_6095_().m_20676_().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            ((BuildingStatisticsModule)((AbstractBuildingGuards)((AbstractEntityAIGuard)parentAI).building).getModule(BuildingModules.STATS_MODULE)).increment("mob_killed;" + translatableContents.m_237508_());
        }
    }

    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)((AbstractEntityCitizen)this.user), (LivingEntity)entity);
    }

    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)((AbstractEntityCitizen)this.user), (LivingEntity)this.target, (int)1600);
    }

    @Override
    @NotNull
    public T getParentAI() {
        return this.parentAI;
    }
}

