/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.constant.IToolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public abstract class GenericedRecipeStorage<GENERIC extends IGenericRecipe>
implements ICustomizedRecipeStorage {
    @NotNull
    protected abstract GENERIC getGenericRecipe();

    public int getGridSize() {
        return this.getGenericRecipe().getGridSize();
    }

    public ItemStack getPrimaryOutput() {
        return this.getGenericRecipe().getPrimaryOutput();
    }

    public List<ItemStack> getAlternateOutputs() {
        return this.getGenericRecipe().getAdditionalOutputs();
    }

    public List<ItemStack> getSecondaryOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.addAll(this.getGenericRecipe().getAdditionalOutputs());
        list.addAll(ItemStorageHelper.getCraftingRemainings(this.getInput()));
        return Collections.unmodifiableList(list);
    }

    public Block getIntermediate() {
        return this.getGenericRecipe().getIntermediate();
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceLocation getLootTable() {
        return this.getGenericRecipe().getLootTable();
    }

    public IToolType getRequiredTool() {
        return this.getGenericRecipe().getRequiredTool();
    }
}

