/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.PathJobFindWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.WorkingBlocksPathResult;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;

public abstract class AbstractModuleWithExternalWorkingBlocks
extends AbstractCraftingBuildingModule.Custom
implements IModuleWithExternalWorkingBlocks {
    public static final String TAG_REGISTERED_POSITIONS = MineColoniesCompatibility.rl("registered_positions").toString();
    private final Set<BlockPos> workingPositions = new HashSet<BlockPos>();
    private WorkingBlocksPathResult pathReuslt;

    public AbstractModuleWithExternalWorkingBlocks(JobEntry jobEntry) {
        super(jobEntry);
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.workingPositions.clear();
        this.workingPositions.addAll(BlockPosUtil.readPosListFromNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS));
    }

    public void serializeNBT(@NotNull CompoundTag compound) {
        super.serializeNBT(compound);
        BlockPosUtil.writePosListToNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS, new ArrayList<BlockPos>(this.workingPositions));
    }

    @Override
    @NotNull
    public PathJobFindWorkingBlocks<?> createWorkingBlocksFindPath(@Nullable AbstractEntityCitizen citizen) {
        Tuple corners = this.building.getCorners();
        IColony colony = this.building.getColony();
        PathJobFindWorkingBlocks<WorkingBlocksPathResult> job = new PathJobFindWorkingBlocks<WorkingBlocksPathResult>(colony.getWorld(), citizen != null ? citizen.m_20183_() : this.building.getID(), BoundingBox.m_162375_((Vec3i)((Vec3i)corners.m_14418_()), (Vec3i)((Vec3i)corners.m_14419_())), (Mob)citizen, this.createPathResult(citizen));
        if (citizen != null) {
            job.setPathingOptions(citizen.getNavigation().getPathingOptions());
        } else {
            IResearchEffectManager researchEffects = colony.getResearchManager().getResearchEffects();
            PathingOptions options = job.getPathingOptions();
            options.setEnterDoors(true);
            options.setCanOpenDoors(true);
            options.setCanUseRails(researchEffects.getEffectStrength(ResearchConstants.RAILS) > 0.0);
            options.setCanClimbAdvanced(researchEffects.getEffectStrength(ResearchConstants.VINES) > 0.0);
        }
        return job;
    }

    @Override
    public boolean requestFindWorkingBlocks(@Nullable AbstractEntityCitizen citizen) {
        if (this.pathReuslt == null) {
            this.pathReuslt = (WorkingBlocksPathResult)this.createWorkingBlocksFindPath(citizen).getResult();
            this.pathReuslt.startJob(Pathfinding.getExecutor());
            return true;
        }
        if (this.pathReuslt.isDone()) {
            this.workingPositions.addAll(this.pathReuslt.positions);
            this.pathReuslt = null;
            return false;
        }
        return true;
    }

    protected abstract WorkingBlocksPathResult createPathResult(@Nullable AbstractEntityCitizen var1);

    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        ICitizenData data = ((WorkerBuildingModule)this.building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getFirstCitizen();
        AbstractEntityCitizen worker = data != null ? (AbstractEntityCitizen)data.getEntity().orElse(null) : null;
        this.requestFindWorkingBlocks(worker);
    }

    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level level) {
        this.addWorkingBlock(pos);
    }

    @Override
    public boolean addWorkingBlock(@NotNull BlockPos pos) {
        BlockState state;
        Level level = this.building.getColony().getWorld();
        return this.isWorkingBlock((LevelReader)level, pos, state = level.m_8055_(pos)) && this.workingPositions.add(pos);
    }

    @Override
    public boolean removeWorkingBlock(@Nullable BlockPos pos) {
        return this.workingPositions.remove(pos);
    }

    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.workingPositions);
    }
}

