/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.block.entity.CheeseFormBlockEntity;
import net.satisfy.meadow.block.entity.CheeseRackBlockEntity;
import net.satisfy.meadow.block.entity.CookingCauldronBlockEntity;
import net.satisfy.meadow.block.entity.FondueBlockEntity;
import net.satisfy.meadow.block.entity.StoveBlockEntity;
import net.satisfy.meadow.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<CookingCauldronBlockEntity>> COOKING_CAULDRON = BlockEntityRegistry.createBlockEntity("cooking_cauldron", () -> BlockEntityType.Builder.m_155273_(CookingCauldronBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_CAULDRON.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CheeseFormBlockEntity>> CHEESE_FORM_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("cheese_form", () -> BlockEntityType.Builder.m_155273_(CheeseFormBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_FORM.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CheeseRackBlockEntity>> CHEESE_RACK_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("cheese_rack", () -> BlockEntityType.Builder.m_155273_(CheeseRackBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_RACK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FondueBlockEntity>> FONDUE = BlockEntityRegistry.createBlockEntity("fondue", () -> BlockEntityType.Builder.m_155273_(FondueBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FONDUE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("stove_block_entity", () -> BlockEntityType.Builder.m_155273_(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STOVE_LID.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> createBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Meadow.LOGGER.debug("Registering Mod BlockEntities for meadow");
        BLOCK_ENTITY_TYPES.register();
    }
}

