/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.meadow.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class WoodenBucket
extends BucketItem {
    private final Fluid fluid;

    public WoodenBucket(Fluid fluid, Item.Properties settings) {
        super(fluid, settings);
        this.fluid = fluid;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        BlockHitResult blockHitResult = WoodenBucket.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)(this.fluid == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos3;
            BlockPos blockPos = blockHitResult.m_82425_();
            Direction direction = blockHitResult.m_82434_();
            BlockPos blockPos2 = blockPos.m_121945_(direction);
            if (!world.m_7966_(user, blockPos) || !user.m_36204_(blockPos2, direction, itemStack)) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (this.fluid == Fluids.f_76191_) {
                BlockState blockState = world.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (block instanceof BucketPickup) {
                    BucketPickup f = (BucketPickup)block;
                    if (!blockState.m_60819_().m_76170_() || blockState.m_60734_().equals(Blocks.f_49991_) || blockState.m_60734_().equals(Blocks.f_152499_)) {
                        return InteractionResultHolder.m_19098_((Object)itemStack);
                    }
                    BucketPickup fluidDrainable = f;
                    ItemStack itemStack2 = fluidDrainable.m_142598_((LevelAccessor)world, blockPos, blockState);
                    if (itemStack2.m_41619_()) {
                        return InteractionResultHolder.m_19098_((Object)itemStack);
                    }
                    if (itemStack2.m_41720_().equals(Items.f_42447_)) {
                        itemStack2 = new ItemStack((ItemLike)ObjectRegistry.WOODEN_WATER_BUCKET.get());
                    }
                    user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    fluidDrainable.m_142298_().ifPresent(sound -> user.m_5496_(sound, 1.0f, 1.0f));
                    world.m_142346_((Entity)user, GameEvent.f_157816_, blockPos);
                    ItemStack itemStack3 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)user, (ItemStack)itemStack2);
                    if (!world.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)user, itemStack2);
                    }
                    return InteractionResultHolder.m_19092_((Object)itemStack3, (boolean)world.m_5776_());
                }
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            BlockState blockState = world.m_8055_(blockPos);
            BlockPos blockPos4 = blockPos3 = blockState.m_60734_() instanceof LiquidBlockContainer && this.fluid == Fluids.f_76193_ ? blockPos : blockPos2;
            if (this.m_142073_(user, world, blockPos3, blockHitResult)) {
                this.m_142131_(user, world, itemStack, blockPos3);
                if (user instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)user, blockPos3, itemStack);
                }
                user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)WoodenBucket.getEmptySuccessItem(itemStack, user), (boolean)world.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(world, user, hand);
    }

    @NotNull
    public static ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        if (!player.m_150110_().f_35937_) {
            return new ItemStack((ItemLike)ObjectRegistry.WOODEN_BUCKET.get());
        }
        return stack;
    }
}

