/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.block.storage;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.meadow.registry.StorageTypeRegistry;
import net.satisfy.meadow.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class CheeseRackBlock
extends StorageBlock {
    public CheeseRackBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof StorageBlockEntity)) {
            return InteractionResult.PASS;
        }
        StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
        Optional optional = Util.getRelativeHitCoordinatesForBlockFace((BlockHitResult)hit, (Direction)((Direction)state.m_61143_((Property)f_54117_)), (Direction[])this.unAllowedDirections());
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        Tuple ff = (Tuple)optional.get();
        int i = this.getSection((Float)ff.m_14418_(), (Float)ff.m_14419_());
        if (i == Integer.MIN_VALUE || i >= shelfBlockEntity.getInventory().size()) {
            return InteractionResult.PASS;
        }
        if (!((ItemStack)shelfBlockEntity.getInventory().get(i)).m_41619_()) {
            this.remove(world, pos, player, shelfBlockEntity, i);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.canInsertStack(stack)) {
            this.add(world, pos, player, shelfBlockEntity, stack, i);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public int size() {
        return 2;
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.CHEESE_RACK;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.UP, Direction.DOWN};
    }

    public boolean canInsertStack(ItemStack itemStack) {
        return itemStack.m_204117_(TagRegistry.CHEESE_BLOCKS);
    }

    public int getSection(Float x, Float y) {
        int index;
        int n = index = (double)y.floatValue() > 0.5 ? 1 : 0;
        if (index >= this.size()) {
            return Integer.MIN_VALUE;
        }
        return index;
    }

    public SoundEvent getRemoveSound(Level level, BlockPos blockPos, Player player, int i) {
        return SoundEvents.f_12639_;
    }

    public SoundEvent getAddSound(Level level, BlockPos blockPos, Player player, int i) {
        return SoundEvents.f_12642_;
    }
}

