/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.block.StoveBlockBench;
import net.satisfy.meadow.block.entity.StoveBlockEntity;
import net.satisfy.meadow.registry.BlockEntityRegistry;
import net.satisfy.meadow.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockSmoker
extends SmokerBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    public static final VoxelShape SHAPE_BIG = Shapes.m_83110_((VoxelShape)StoveBlockBench.SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private final Direction directionToCheck;

    public StoveBlockSmoker(BlockBehaviour.Properties properties, Direction directionToCheck) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.directionToCheck = directionToCheck;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.directionToCheck == Direction.DOWN && ((Boolean)state.m_61143_((Property)CONNECTED)).booleanValue()) {
            return super.m_5940_(state, world, pos, context);
        }
        return SHAPE_BIG;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        List<Block> block = this.getBlocksToCheck();
        if (!block.isEmpty() && block.contains(ctx.m_43725_().m_8055_(ctx.m_8083_().m_121945_(this.directionToCheck)).m_60734_())) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_48683_, (Comparable)ctx.m_8125_().m_122424_());
        }
        return super.m_5573_(ctx);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        List<Block> block = this.getBlocksToCheck();
        if (!world.m_5776_() && !block.isEmpty() && direction == this.directionToCheck) {
            boolean connected = (Boolean)state.m_61143_((Property)CONNECTED);
            if (!connected) {
                if (block.contains(neighborState.m_60734_())) {
                    return (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(true));
                }
            } else if (!block.contains(neighborState.m_60734_())) {
                return (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
            }
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED});
    }

    private List<Block> getBlocksToCheck() {
        if (this.directionToCheck == Direction.UP) {
            return List.of((Block)ObjectRegistry.STOVE.get());
        }
        if (this.directionToCheck == Direction.DOWN) {
            return List.of((Block)ObjectRegistry.STOVE_WOOD.get(), (Block)ObjectRegistry.STOVE_LID.get());
        }
        return List.of();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return StoveBlockSmoker.m_151987_((Level)level, blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.STOVE_BLOCK_ENTITY.get()));
    }
}

