/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import snownee.lychee.client.gui.ILightingSettings;

public class CachedRenderingEntity<T extends Entity> {
    private Function<Level, T> factory;
    protected T entity;
    protected float scale = 15.0f;

    public static <T extends Entity> CachedRenderingEntity<T> of(@NotNull T entity) {
        return new CachedRenderingEntity<T>(entity);
    }

    public static <T extends Entity> CachedRenderingEntity<T> ofFactory(Function<Level, T> factory) {
        return new CachedRenderingEntity<T>(factory);
    }

    protected CachedRenderingEntity(@NotNull T entity) {
        this.setEntity(entity);
    }

    protected CachedRenderingEntity(Function<Level, T> factory) {
        this.factory = factory;
    }

    private void ensureEntity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull((Entity)this.factory.apply((Level)Minecraft.m_91087_().f_91073_));
            this.factory = null;
        }
    }

    public T getEntity() {
        this.ensureEntity();
        ((Entity)this.entity).f_19797_ = Minecraft.m_91087_().f_91074_.f_19797_;
        return this.entity;
    }

    public void setEntity(@NotNull T entity) {
        this.entity = entity;
        this.factory = null;
        entity.m_284535_(null);
    }

    public T earlySetLevel() {
        this.ensureEntity();
        this.entity.m_284535_((Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_));
        return this.entity;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void render(PoseStack matrixStack, float x, float y, float z, Quaternionf rotation) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        this.ensureEntity();
        this.entity.m_284535_((Level)mc.f_91073_);
        ((Entity)this.entity).f_19797_ = mc.f_91074_.f_19797_;
        Vec3 position = mc.f_91074_.m_20182_();
        this.entity.m_20343_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, z);
        matrixStack.m_85841_(this.scale, this.scale, this.scale);
        matrixStack.m_252781_(rotation);
        EntityRenderDispatcher renderDispatcher = mc.m_91290_();
        rotation.conjugate();
        renderDispatcher.m_252923_(rotation);
        renderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        renderDispatcher.m_114384_(this.entity, 0.0, 0.0, 0.0, mc.m_91296_(), 1.0f, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        renderDispatcher.m_114468_(true);
        matrixStack.m_85849_();
        this.entity.m_284535_(null);
        ILightingSettings.DEFAULT_3D.applyLighting();
    }
}

