/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DamageItem
extends PostAction {
    public final int damage;
    public final Reference target;

    public DamageItem(int damage, Reference target) {
        this.damage = damage;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        Entity thisEntity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        for (Integer index : indexes) {
            Consumer<LivingEntity> onBroken;
            ItemStack stack = ctx.m_8020_(index);
            if (!stack.m_41763_()) {
                return;
            }
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
            stack = ctx.itemHolders.split(index, 1).get();
            int damage = this.damage;
            LivingEntity living = null;
            InteractionHand hand = null;
            if (thisEntity instanceof LivingEntity) {
                living = (LivingEntity)thisEntity;
                if (living.m_21205_() == stack) {
                    hand = InteractionHand.MAIN_HAND;
                } else if (living.m_21206_() == stack) {
                    hand = InteractionHand.OFF_HAND;
                }
            }
            if (hand == null) {
                onBroken = $ -> {};
            } else {
                InteractionHand hand2 = hand;
                onBroken = $ -> $.m_21190_(hand2);
            }
            if (!stack.m_220157_(damage, ctx.getRandom(), thisEntity instanceof ServerPlayer ? (ServerPlayer)thisEntity : null)) continue;
            if (thisEntity instanceof LivingEntity) {
                onBroken.accept((LivingEntity)thisEntity);
            }
            Item item = stack.m_41720_();
            stack.m_41774_(1);
            if (thisEntity instanceof Player) {
                ((Player)thisEntity).m_36246_(Stats.f_12983_.m_12902_((Object)item));
            }
            stack.m_41721_(0);
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    extends PostActionType<DamageItem> {
        @Override
        public DamageItem fromJson(JsonObject o) {
            return new DamageItem(GsonHelper.m_13824_((JsonObject)o, (String)"damage", (int)1), Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(DamageItem action, JsonObject o) {
            if (action.damage != 1) {
                o.addProperty("damage", (Number)1);
            }
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public DamageItem fromNetwork(FriendlyByteBuf buf) {
            return new DamageItem(buf.m_130242_(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(DamageItem action, FriendlyByteBuf buf) {
            buf.m_130130_(action.damage);
            Reference.toNetwork(action.target, buf);
        }
    }
}

