/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.PostActionTypes;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.NbtPredicateAccess;
import snownee.lychee.mixin.StatePropertiesPredicateAccess;
import snownee.lychee.util.CommonProxy;

public class PlaceBlock
extends PostAction {
    public final BlockPredicate block;
    public final BlockPos offset;

    public PlaceBlock(BlockPredicate block, BlockPos offset) {
        this.block = block;
        this.offset = offset;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.PLACE;
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        BlockEntity blockentity;
        BlockPos pos = ctx.getParamOrNull(LycheeLootContextParams.BLOCK_POS);
        if (pos == null) {
            pos = BlockPos.m_274446_((Position)((Position)ctx.getParam(LootContextParams.f_81460_)));
        }
        pos = pos.m_121955_((Vec3i)this.offset);
        ServerLevel level = ctx.getServerLevel();
        BlockState oldState = level.m_8055_(pos);
        BlockState state = this.getNewState(oldState);
        if (state == null) {
            return;
        }
        if (state.m_60795_()) {
            PlaceBlock.destroyBlock((Level)level, pos, false);
            return;
        }
        if (recipe instanceof BlockCrushingRecipe && !oldState.m_60795_()) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)oldState));
        }
        BlockPredicateAccess access = (BlockPredicateAccess)this.block;
        if (this.getType() == PostActionTypes.PLACE) {
            Set properties = ((StatePropertiesPredicateAccess)access.getProperties()).getProperties().stream().map($ -> $.m_67726_()).collect(Collectors.toSet());
            for (Map.Entry entry : oldState.m_61148_().entrySet()) {
                Property property = (Property)entry.getKey();
                if (properties.contains(property.m_61708_()) || !state.m_61138_(property)) continue;
                state = (BlockState)state.m_61124_(property, (Comparable)entry.getValue());
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && oldState.m_60819_().m_164512_((Fluid)Fluids.f_76193_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
        }
        if (!level.m_46597_(pos, state)) {
            return;
        }
        NbtPredicate nbtPredicate = access.getNbt();
        if (this.getType() == PostActionTypes.PLACE && nbtPredicate != NbtPredicate.f_57471_ && (blockentity = level.m_7702_(pos)) != null) {
            CompoundTag compoundtag1 = blockentity.m_187482_();
            CompoundTag compoundtag2 = compoundtag1.m_6426_();
            compoundtag1.m_128391_(((NbtPredicateAccess)nbtPredicate).getTag());
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.m_142466_(compoundtag1);
                blockentity.m_6596_();
            }
        }
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
    }

    @Nullable
    protected BlockState getNewState(BlockState oldState) {
        return BlockPredicateHelper.anyBlockState(this.block);
    }

    private static boolean destroyBlock(Level level, BlockPos pos, boolean drop) {
        boolean flag;
        BlockState legacy;
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(pos);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
        }
        if (drop) {
            BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(pos) : null;
            Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)pos, (BlockEntity)blockentity, null, (ItemStack)ItemStack.f_41583_);
        }
        if ((legacy = fluidstate.m_76188_()) == blockstate) {
            legacy = Blocks.f_50016_.m_49966_();
        }
        if (flag = level.m_6933_(pos, legacy, 3, 512)) {
            level.m_142346_(null, GameEvent.f_157794_, pos);
        }
        return flag;
    }

    @Override
    public Component getDisplayName() {
        BlockState state = BlockPredicateHelper.anyBlockState(this.block);
        String key = CommonProxy.makeDescriptionId("postAction", PostActionTypes.PLACE.getRegistryName());
        if (state.m_60795_()) {
            return Component.m_237115_((String)(key + ".consume"));
        }
        return Component.m_237110_((String)key, (Object[])new Object[]{state.m_60734_().m_49954_()});
    }

    @Override
    public List<ItemStack> getItemOutputs() {
        return BlockPredicateHelper.getMatchedItemStacks(this.block);
    }

    @Override
    public List<BlockPredicate> getBlockOutputs() {
        return List.of(this.block);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    public static class Type
    extends PostActionType<PlaceBlock> {
        @Override
        public PlaceBlock fromJson(JsonObject o) {
            return new PlaceBlock(BlockPredicateHelper.fromJson(o.get("block")), CommonProxy.parseOffset(o));
        }

        @Override
        public void toJson(PlaceBlock action, JsonObject o) {
            BlockPos offset = action.offset;
            if (offset.m_123341_() != 0) {
                o.addProperty("offsetX", (Number)offset.m_123341_());
            }
            if (offset.m_123342_() != 0) {
                o.addProperty("offsetY", (Number)offset.m_123342_());
            }
            if (offset.m_123343_() != 0) {
                o.addProperty("offsetZ", (Number)offset.m_123341_());
            }
            o.add("block", BlockPredicateHelper.toJson(action.block));
        }

        @Override
        public PlaceBlock fromNetwork(FriendlyByteBuf buf) {
            return new PlaceBlock(BlockPredicateHelper.fromNetwork(buf), buf.m_130135_());
        }

        @Override
        public void toNetwork(PlaceBlock action, FriendlyByteBuf buf) {
            BlockPredicateHelper.toNetwork(action.block, buf);
            buf.m_130064_(action.offset);
        }
    }
}

