/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.def;

import java.util.Optional;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.def.DoubleBoundsHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.mixin.LightPredicateAccess;
import snownee.lychee.mixin.LocationPredicateAccess;
import snownee.lychee.util.CommonProxy;

public interface LocationPredicateHelper {
    public static LocationPredicate.Builder fromNetwork(FriendlyByteBuf pBuffer) {
        byte smokey;
        ResourceLocation feature;
        ResourceLocation biome;
        ResourceLocation dim;
        LocationPredicate.Builder builder = LocationPredicate.Builder.m_52651_();
        builder.m_153970_(DoubleBoundsHelper.fromNetwork(pBuffer));
        builder.m_153974_(DoubleBoundsHelper.fromNetwork(pBuffer));
        builder.m_153978_(DoubleBoundsHelper.fromNetwork(pBuffer));
        builder.m_52652_(BlockPredicateHelper.fromNetwork(pBuffer));
        MinMaxBounds.Ints ints = IntBoundsHelper.fromNetwork(pBuffer);
        if (ints != MinMaxBounds.Ints.f_55364_) {
            builder.m_153968_(LightPredicate.Builder.m_153103_().m_153104_(ints).m_153106_());
        }
        if ((dim = CommonProxy.readNullableRL(pBuffer)) != null) {
            builder.m_153976_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim));
        }
        if ((biome = CommonProxy.readNullableRL(pBuffer)) != null) {
            builder.m_52656_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biome));
        }
        if ((feature = CommonProxy.readNullableRL(pBuffer)) != null) {
            builder.m_220592_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)feature));
        }
        if ((smokey = pBuffer.readByte()) < 2) {
            builder.m_52654_(Boolean.valueOf(smokey == 1));
        }
        return builder;
    }

    public static void toNetwork(LocationPredicate predicate, FriendlyByteBuf pBuffer) {
        LocationPredicateAccess access = (LocationPredicateAccess)predicate;
        DoubleBoundsHelper.toNetwork(access.getX(), pBuffer);
        DoubleBoundsHelper.toNetwork(access.getY(), pBuffer);
        DoubleBoundsHelper.toNetwork(access.getZ(), pBuffer);
        BlockPredicateHelper.toNetwork(access.getBlock(), pBuffer);
        MinMaxBounds.Ints ints = ((LightPredicateAccess)access.getLight()).getComposite();
        IntBoundsHelper.toNetwork(ints, pBuffer);
        ResourceLocation dim = Optional.ofNullable(access.getDimension()).map(ResourceKey::m_135782_).orElse(null);
        CommonProxy.writeNullableRL(dim, pBuffer);
        ResourceLocation biome = Optional.ofNullable(access.getBiome()).map(ResourceKey::m_135782_).orElse(null);
        CommonProxy.writeNullableRL(biome, pBuffer);
        ResourceLocation feature = Optional.ofNullable(access.getStructure()).map(ResourceKey::m_135782_).orElse(null);
        CommonProxy.writeNullableRL(feature, pBuffer);
        Boolean smokey = access.getSmokey();
        if (smokey == null) {
            pBuffer.writeByte(2);
        } else {
            pBuffer.writeByte(smokey != false ? 1 : 0);
        }
    }

    public void lychee$setBiomeTag(TagKey<Biome> var1);

    public TagKey<Biome> lychee$getBiomeTag();
}

