/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.compat.jei.category.BaseJEICategory;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class CraftingRecipeCategoryExtension
implements ICraftingCategoryExtension {
    private static final Rect2i infoRect = new Rect2i(67, 11, 8, 8);
    private final ILycheeRecipe<?> recipe;

    public CraftingRecipeCategoryExtension(ILycheeRecipe<?> recipe) {
        this.recipe = recipe;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, GuiGraphics graphics, double mouseX, double mouseY) {
        BaseJEICategory.drawInfoBadge(this.recipe, graphics, mouseX, mouseY, infoRect);
    }

    public List<Component> getTooltipStrings(double mouseX, double mouseY) {
        return BaseJEICategory.getTooltipStrings(this.recipe, mouseX, mouseY, infoRect);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        CraftingRecipe craftingRecipe = (CraftingRecipe)this.recipe;
        List<List> inputs = craftingRecipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        ItemStack resultItem = craftingRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
        int width = this.getWidth();
        int height = this.getHeight();
        craftingGridHelper.createAndSetOutputs(builder, List.of(resultItem));
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return ((Recipe)this.recipe).m_6423_();
    }

    public int getHeight() {
        int n;
        ILycheeRecipe<?> iLycheeRecipe = this.recipe;
        if (iLycheeRecipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)iLycheeRecipe;
            n = shaped.m_44221_();
        } else {
            n = 0;
        }
        return n;
    }

    public int getWidth() {
        int n;
        ILycheeRecipe<?> iLycheeRecipe = this.recipe;
        if (iLycheeRecipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)iLycheeRecipe;
            n = shaped.m_44220_();
        } else {
            n = 0;
        }
        return n;
    }
}

