/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.block_crushing;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.util.RecipeMatcher;

public class BlockCrushingRecipe
extends LycheeRecipe<BlockCrushingContext>
implements BlockKeyRecipe<BlockCrushingRecipe> {
    public static final BlockPredicate ANVIL = BlockPredicate.Builder.m_17924_().m_204027_(BlockTags.f_13033_).m_17931_();
    protected BlockPredicate fallingBlock = ANVIL;
    protected BlockPredicate landingBlock = BlockPredicate.f_17902_;
    protected NonNullList<Ingredient> ingredients = NonNullList.m_122779_();

    public BlockCrushingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(BlockCrushingContext ctx, Level pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateHelper.fastMatch(this.landingBlock, ctx)) {
            return false;
        }
        if (!this.matchesFallingBlock(ctx.fallingBlock.m_31980_(), ctx.fallingBlock.f_31944_)) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<ItemEntity> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.test($.m_32055_()))).limit(27L).toList();
        List<ItemStack> items = itemEntities.stream().map(ItemEntity::m_32055_).toList();
        Optional<RecipeMatcher<ItemStack>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(ItemStack::m_41613_).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    public boolean matchesFallingBlock(BlockState blockstate, CompoundTag nbt) {
        if (this.fallingBlock == BlockPredicate.f_17902_) {
            return true;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)this.fallingBlock;
        if (access.getTag() != null && !blockstate.m_204336_(access.getTag())) {
            return false;
        }
        if (access.getBlocks() != null && !access.getBlocks().contains(blockstate.m_60734_())) {
            return false;
        }
        if (!access.getProperties().m_67667_(blockstate)) {
            return false;
        }
        if (access.getNbt() != NbtPredicate.f_57471_) {
            return nbt != null && access.getNbt().m_57483_((Tag)nbt);
        }
        return true;
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.BLOCK_CRUSHING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.BLOCK_CRUSHING;
    }

    @Override
    public BlockPredicate getBlock() {
        return this.fallingBlock;
    }

    public BlockPredicate getLandingBlock() {
        return this.landingBlock;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public List<BlockPredicate> getBlockInputs() {
        return List.of(this.fallingBlock, this.landingBlock);
    }

    @Override
    public int compareTo(BlockCrushingRecipe that) {
        int i = Integer.compare(this.getMaxRepeats().m_55327_() ? 1 : 0, that.getMaxRepeats().m_55327_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.m_5598_() ? 1 : 0, that.m_5598_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.landingBlock == BlockPredicate.f_17902_ ? 1 : 0, that.landingBlock == BlockPredicate.f_17902_ ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), that.ingredients.size());
        if (i != 0) {
            return i;
        }
        return this.m_6423_().compareTo(that.m_6423_());
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<BlockCrushingRecipe> {
        public Serializer() {
            super(BlockCrushingRecipe::new);
        }

        @Override
        public void fromJson(BlockCrushingRecipe pRecipe, JsonObject pSerializedRecipe) {
            if (pSerializedRecipe.has("falling_block")) {
                pRecipe.fallingBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("falling_block"));
            }
            if (pSerializedRecipe.has("landing_block")) {
                pRecipe.landingBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("landing_block"));
            }
            if (pSerializedRecipe.has("item_in")) {
                JsonElement itemIn = pSerializedRecipe.get("item_in");
                if (itemIn.isJsonArray()) {
                    itemIn.getAsJsonArray().forEach($ -> pRecipe.ingredients.add((Object)Ingredient.m_43917_((JsonElement)$)));
                } else {
                    pRecipe.ingredients.add((Object)Ingredient.m_43917_((JsonElement)itemIn));
                }
                Preconditions.checkArgument((pRecipe.ingredients.size() <= 27 ? 1 : 0) != 0, (String)"Ingredients cannot be more than %s", (int)27);
            }
        }

        @Override
        public void fromNetwork(BlockCrushingRecipe pRecipe, FriendlyByteBuf pBuffer) {
            pRecipe.fallingBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pRecipe.landingBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pBuffer.m_236838_(i -> pRecipe.ingredients, Ingredient::m_43940_);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, BlockCrushingRecipe pRecipe) {
            BlockPredicateHelper.toNetwork(pRecipe.fallingBlock, pBuffer);
            BlockPredicateHelper.toNetwork(pRecipe.landingBlock, pBuffer);
            pBuffer.m_236828_(pRecipe.ingredients, (b, i) -> i.m_43923_(b));
        }
    }
}

