/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.item.crafting;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.item.crafting.BucketFillingType;
import cech12.bucketlib.util.BucketLibUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketFillingShapedRecipe
extends ShapedRecipe {
    private final CraftingBookCategory category;
    private final List<Ingredient> ingredients;
    private final BucketFillingType fillingType;
    private final Fluid fluid;
    private final Block block;
    private final EntityType<?> entityType;

    public BucketFillingShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, BucketFillingType fillingType, Fluid fluid, Block block, EntityType<?> entityType) {
        super(id, group, category, width, height, ingredients, BucketFillingShapedRecipe.getAssembledBucket(fillingType, fluid, block, entityType, ingredients.stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).toList()).flatMap(Collection::stream).toList()));
        this.category = category;
        this.ingredients = ingredients;
        this.fillingType = fillingType;
        this.fluid = fluid;
        this.block = block;
        this.entityType = entityType;
    }

    private static ItemStack getAffectedBucket(List<ItemStack> itemStacks) {
        for (ItemStack stack : itemStacks) {
            if (!(stack.m_41720_() instanceof UniversalBucketItem) || !BucketLibUtil.isEmpty(stack)) continue;
            ItemStack bucket = stack.m_41777_();
            bucket.m_41764_(1);
            return bucket;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getAssembledBucket(BucketFillingType fillingType, Fluid fluid, Block block, EntityType<?> entityType, List<ItemStack> itemStacks) {
        ItemStack bucket = BucketFillingShapedRecipe.getAffectedBucket(itemStacks);
        Item item = bucket.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem universalBucketItem = (UniversalBucketItem)item;
            if (fillingType == BucketFillingType.BLOCK && universalBucketItem.canHoldBlock(block)) {
                return BucketLibUtil.addBlock(bucket, block);
            }
            if (fillingType == BucketFillingType.ENTITY && universalBucketItem.canHoldEntity(entityType) && (fluid == null || universalBucketItem.canHoldFluid(fluid))) {
                if (fluid != null) {
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                }
                return BucketLibUtil.addEntityType(bucket, entityType);
            }
            if (fillingType == BucketFillingType.FLUID && universalBucketItem.canHoldFluid(fluid)) {
                return BucketLibUtil.addFluid(bucket, fluid);
            }
            if (fillingType == BucketFillingType.MILK && universalBucketItem.canMilkEntities()) {
                return BucketLibUtil.addMilk(bucket);
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        ItemStack bucket = BucketFillingShapedRecipe.getAffectedBucket(inv.m_280657_());
        if (bucket == ItemStack.f_41583_) {
            return false;
        }
        UniversalBucketItem universalBucketItem = (UniversalBucketItem)bucket.m_41720_();
        return !(!super.m_5818_(inv, level) || this.fillingType == BucketFillingType.BLOCK && !universalBucketItem.canHoldBlock(this.block) || this.fillingType == BucketFillingType.ENTITY && (!universalBucketItem.canHoldEntity(this.entityType) || this.fluid != null && !universalBucketItem.canHoldFluid(this.fluid)) || this.fillingType == BucketFillingType.FLUID && !universalBucketItem.canHoldFluid(this.fluid) || this.fillingType == BucketFillingType.MILK && !universalBucketItem.canMilkEntities());
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        return BucketFillingShapedRecipe.getAssembledBucket(this.fillingType, this.fluid, this.block, this.entityType, inv.m_280657_());
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BucketFillingShapedRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public BucketFillingShapedRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            try {
                Method dissolvePatternMethod;
                Method patternFromJsonMethod;
                Method shrinkMethod;
                Method keyFromJsonMethod;
                try {
                    keyFromJsonMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"keyFromJson", (Class[])new Class[]{JsonObject.class});
                    shrinkMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"shrink", (Class[])new Class[]{String[].class});
                    patternFromJsonMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"patternFromJson", (Class[])new Class[]{JsonArray.class});
                    dissolvePatternMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"dissolvePattern", (Class[])new Class[]{String[].class, Map.class, Integer.TYPE, Integer.TYPE});
                }
                catch (ObfuscationReflectionHelper.UnableToFindMethodException ex) {
                    keyFromJsonMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"m_44210_", (Class[])new Class[]{JsonObject.class});
                    shrinkMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"m_44186_", (Class[])new Class[]{String[].class});
                    patternFromJsonMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"m_44196_", (Class[])new Class[]{JsonArray.class});
                    dissolvePatternMethod = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"m_44202_", (Class[])new Class[]{String[].class, Map.class, Integer.TYPE, Integer.TYPE});
                }
                Map map = (Map)keyFromJsonMethod.invoke(null, GsonHelper.m_13930_((JsonObject)json, (String)"key"));
                String[] pattern = (String[])patternFromJsonMethod.invoke(null, GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
                String[] shrinkedPattern = (String[])shrinkMethod.invoke(null, new Object[]{pattern});
                int width = shrinkedPattern[0].length();
                int height = shrinkedPattern.length;
                NonNullList ingredients = (NonNullList)dissolvePatternMethod.invoke(null, shrinkedPattern, map, width, height);
                BucketFillingType fillingType = (BucketFillingType)BucketFillingType.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"filling_type", null), (Enum)BucketFillingType.FLUID);
                Fluid fluid = null;
                Block block = null;
                EntityType entityType = null;
                if (fillingType == BucketFillingType.BLOCK) {
                    if (!json.has("block")) {
                        throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"block\" without a defined block.");
                    }
                    block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()));
                } else if (fillingType == BucketFillingType.ENTITY) {
                    if (!json.has("entity")) {
                        throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"entity\" without a defined entity.");
                    }
                    entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("entity").getAsString()));
                    fluid = json.has("fluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("fluid").getAsString())) : null;
                } else if (fillingType == BucketFillingType.FLUID) {
                    if (!json.has("fluid")) {
                        throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"fluid\" without a defined fluid.");
                    }
                    fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(json.get("fluid").getAsString()));
                } else if (fillingType != BucketFillingType.MILK) {
                    throw new JsonParseException("Cannot create a bucket filling recipe of fillingType \"" + fillingType + "\".");
                }
                return new BucketFillingShapedRecipe(id, s, category, width, height, (NonNullList<Ingredient>)ingredients, fillingType, fluid, block, entityType);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        public BucketFillingShapedRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String s = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList recipeItems = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            recipeItems.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            BucketFillingType fillingType = (BucketFillingType)buffer.m_130066_(BucketFillingType.class);
            Fluid fluid = null;
            Block block = null;
            EntityType entityType = null;
            if (fillingType == BucketFillingType.BLOCK) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
            } else if (fillingType == BucketFillingType.ENTITY) {
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buffer.m_130281_());
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
                if (fluid == Fluids.f_76191_) {
                    fluid = null;
                }
            } else if (fillingType == BucketFillingType.FLUID) {
                fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(buffer.m_130281_());
            }
            return new BucketFillingShapedRecipe(id, s, category, width, height, (NonNullList<Ingredient>)recipeItems, fillingType, fluid, block, entityType);
        }

        public void toNetwork(FriendlyByteBuf buffer, BucketFillingShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.category);
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130068_((Enum)recipe.fillingType);
            if (recipe.fillingType == BucketFillingType.BLOCK) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)recipe.block)));
            } else if (recipe.fillingType == BucketFillingType.ENTITY) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(recipe.entityType)));
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)(recipe.fluid != null ? recipe.fluid : Fluids.f_76191_))));
            } else if (recipe.fillingType == BucketFillingType.FLUID) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)recipe.fluid)));
            }
        }
    }
}

