/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.item.crafting;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.ColorUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class BucketDyeingRecipe
extends CustomRecipe {
    public BucketDyeingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    @Nullable
    private Pair<ItemStack, List<DyeItem>> getBucketAndDyes(@Nonnull CraftingContainer inv) {
        ItemStack bucket = ItemStack.f_41583_;
        ArrayList dyeItems = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof UniversalBucketItem) {
                if (!bucket.m_41619_() || !((UniversalBucketItem)item).isDyeable()) {
                    return null;
                }
                bucket = stack;
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return null;
            }
            dyeItems.add((DyeItem)item);
        }
        if (bucket.m_41619_() || dyeItems.isEmpty()) {
            return null;
        }
        return new Pair((Object)bucket, (Object)dyeItems);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        Pair<ItemStack, List<DyeItem>> bucketAndDyes = this.getBucketAndDyes(inv);
        return bucketAndDyes != null;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess registryAccess) {
        Pair<ItemStack, List<DyeItem>> bucketAndDyes = this.getBucketAndDyes(inv);
        if (bucketAndDyes != null) {
            return ColorUtil.dyeItem((ItemStack)bucketAndDyes.getFirst(), (List)bucketAndDyes.getSecond());
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    extends SimpleCraftingRecipeSerializer<BucketDyeingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public Serializer() {
            super(BucketDyeingRecipe::new);
        }
    }
}

