/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.utils.mixins.LootTableAccessor;

@Mod.EventBusSubscriber(modid="collectibles", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootTableInjection {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Map<String, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation abandoned_mineshaft = LootTableInjection.registerInject("abandoned_mineshaft");
    public static final ResourceLocation jungle_temple = LootTableInjection.registerInject("jungle_temple");
    public static final ResourceLocation stronghold_library = LootTableInjection.registerInject("stronghold_library");
    public static final ResourceLocation bastion_treasure = LootTableInjection.registerInject("bastion_treasure");
    public static final ResourceLocation pillager_outpost = LootTableInjection.registerInject("pillager_outpost");
    public static final ResourceLocation shipwreck_treasure = LootTableInjection.registerInject("shipwreck_treasure");
    public static final ResourceLocation woodland_mansion = LootTableInjection.registerInject("woodland_mansion");
    public static final ResourceLocation buried_treasure = LootTableInjection.registerInject("buried_treasure");
    private static int injected = 0;

    @NotNull
    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = LootTableInjection.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    @NotNull
    static ResourceLocation register(@NotNull String resourceName) {
        return LootTableInjection.register(new ResourceLocation("collectibles", resourceName));
    }

    @NotNull
    static ResourceLocation register(@NotNull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @SubscribeEvent
    public static void onChestLootLoad(@NotNull LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                ((LootTableAccessor)event.getTable()).getPools().add(LootTableInjection.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                Collectibles.LOGGER.error("Loottable {} is broken by some other mod. Cannot add Collectibles loot to it. " + name);
            }
        }
    }

    @NotNull
    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(entryName)).m_79707_(1);
        return LootPool.m_79043_().m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_();
    }

    public static int checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return Math.max(0, INJECTION_TABLES.size() - i);
    }
}

