/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.collectibles.integration;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import xxrexraptorxx.collectibles.main.Collectibles;
import xxrexraptorxx.collectibles.registry.ModItems;
import xxrexraptorxx.collectibles.utils.Config;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("collectibles", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        IIngredientManager ingredientManager = registry.getIngredientManager();
        ArrayList<ItemStack> treasures = new ArrayList<ItemStack>();
        ArrayList<ItemStack> epic_treasures = new ArrayList<ItemStack>();
        for (String item : (List)Config.LOOT_BAG_REWARDS.get()) {
            try {
                treasures.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.substring(item.indexOf(42) + 1, item.indexOf(58)), item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry in the Collectibles 'epic_loot_bag_rewards' config option!");
            }
        }
        for (String item : (List)Config.EPIC_LOOT_BAG_REWARDS.get()) {
            try {
                epic_treasures.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.substring(item.indexOf(42) + 1, item.indexOf(58)), item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
            }
            catch (Exception e) {
                Collectibles.LOGGER.error("Invalid item entry in the Collectibles 'epic_loot_bag_rewards' config option!");
            }
        }
        registry.addIngredientInfo(treasures, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"message.collectibles.lootbag_entry_jei_desc")});
        registry.addIngredientInfo(epic_treasures, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"message.collectibles.epic_lootbag_entry_jei_desc")});
        registry.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.LOOT_BAG.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"message.collectibles.lootbag_jei_desc")});
    }
}

