/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.recipe.architectscutter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchitectsCutterRecipeSerializer
implements RecipeSerializer<ArchitectsCutterRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @NotNull
    public ArchitectsCutterRecipe fromJson(@NotNull ResourceLocation recipeId, JsonObject json) {
        if (json.has("nbt") && json.has("block")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundTag nbt = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
                return new ArchitectsCutterRecipe(recipeId, new ResourceLocation(json.get("block").getAsString()), json.has("count") ? json.get("count").getAsInt() : -1, nbt);
            }
            catch (CommandSyntaxException e) {
                LOGGER.warn("Failed to parse NBT from JSON, skipping.");
            }
        }
        return new ArchitectsCutterRecipe(recipeId, json.has("count") ? json.get("count").getAsInt() : -1);
    }

    @Nullable
    public ArchitectsCutterRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        return new ArchitectsCutterRecipe(recipeId, buffer.m_130281_(), buffer.readInt(), buffer.m_130260_());
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ArchitectsCutterRecipe recipe) {
        buffer.m_130085_(recipe.getBlockName());
        buffer.writeInt(recipe.getCount());
        buffer.m_130079_(recipe.getAdditionalTag());
    }
}

