/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.shingle.normal;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.block.types.ShingleShapeType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ShinglesBlockStateProvider
extends BlockStateProvider {
    public ShinglesBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getShingle(ShingleHeightType.DEFAULT), ShingleHeightType.DEFAULT);
        this.createBlockstateFile(ModBlocks.getInstance().getShingle(ShingleHeightType.FLAT), ShingleHeightType.FLAT);
        this.createBlockstateFile(ModBlocks.getInstance().getShingle(ShingleHeightType.FLAT_LOWER), ShingleHeightType.FLAT_LOWER);
    }

    private void createBlockstateFile(ShingleBlock shingle, ShingleHeightType heightType) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(shingle);
        if (shingle.getRegistryName() == null) {
            return;
        }
        EnumMap<StairsShape, ModelFile> blockModels = new EnumMap<StairsShape, ModelFile>(StairsShape.class);
        for (Direction facingValue : StairBlock.f_56841_.m_6908_()) {
            for (StairsShape shapeValue : ShingleBlock.SHAPE.m_6908_()) {
                for (Half halfValue : StairBlock.f_56842_.m_6908_()) {
                    ShingleShapeType shingleShapeType = ShingleBlock.getTypeFromShape(shapeValue);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(blockModels.computeIfAbsent(shapeValue, shape -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/shingle/" + heightType.getId() + shapeValue.name().toLowerCase(), this.modLoc("block/shingle/" + heightType.getId() + shingleShapeType.name().toLowerCase() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end())).uvLock(false).rotationX(halfValue == Half.TOP ? 180 : 0).rotationY(this.getYFromFacing(facingValue) + this.getYFromShape(shapeValue) + this.getYFromHalf(halfValue, shapeValue)).addModel()).condition((Property)StairBlock.f_56841_, (Comparable[])new Direction[]{facingValue}).condition((Property)StairBlock.f_56843_, (Comparable[])new StairsShape[]{shapeValue}).condition((Property)StairBlock.f_56842_, (Comparable[])new Half[]{halfValue}).end();
                }
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(shingle.getRegistryName().m_135815_())).parent((ModelFile)blockModels.get(StairsShape.STRAIGHT));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String m_6055_() {
        return "Shingles BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 180;
            }
            return 270;
        }
        return 180;
    }

    private int getYFromShape(StairsShape shape) {
        return switch (shape) {
            default -> 0;
            case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> -90;
        };
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 180;
            case Direction.SOUTH -> 270;
            case Direction.WEST -> 0;
            case Direction.NORTH -> 90;
        };
    }
}

