/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.panel;

import com.ldtteam.domumornamentum.block.AbstractPanelBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PanelBlockStateProvider
extends BlockStateProvider {
    public PanelBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)ModBlocks.getInstance().getPanel());
        for (Direction facingValue : BlockStateProperties.f_61374_.m_6908_()) {
            for (TrapdoorType typeValue : TrapdoorBlock.TYPE.m_6908_()) {
                for (Half halfValue : AbstractPanelBlockTrapdoor.HALF.m_6908_()) {
                    Iterator iterator = AbstractPanelBlockTrapdoor.OPEN.m_6908_().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        ConfiguredModel.Builder partBuilder = builder.part();
                        ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/panel/panel_" + typeValue.m_7912_(), this.modLoc("block/panel/panel_%s_spec".formatted(typeValue.m_7912_())))).customLoader(MateriallyTexturedModelBuilder::new)).end()).uvLock(true).rotationY(this.getYFromFacing(facingValue) + this.getYFromOpenAndHalf(openValue, halfValue)).rotationX(this.getXFromOpenAndHalf(openValue, halfValue)).addModel()).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{facingValue}).condition(TrapdoorBlock.TYPE, (Comparable[])new TrapdoorType[]{typeValue}).condition(AbstractPanelBlockTrapdoor.HALF, (Comparable[])new Half[]{halfValue}).condition((Property)AbstractPanelBlockTrapdoor.OPEN, (Comparable[])new Boolean[]{openValue}).end();
                    }
                }
            }
        }
        ItemModelBuilder itemSpecModelBuilder = (ItemModelBuilder)this.itemModels().withExistingParent("panel_spec", this.mcLoc("block/thin_block"));
        TrapdoorType[] values = TrapdoorType.values();
        for (int i = 0; i < values.length; ++i) {
            TrapdoorType value = values[i];
            ItemModelBuilder.OverrideBuilder overrideBuilder = itemSpecModelBuilder.override();
            overrideBuilder.predicate(new ResourceLocation("domum_ornamentum:trapdoor_type"), (float)i);
            overrideBuilder.model((ModelFile)this.itemModels().getExistingFile(this.modLoc("block/panel/panel_%s_spec".formatted(value.m_7912_()))));
            overrideBuilder.end();
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getPanel().getRegistryName().m_135815_())).parent((ModelFile)itemSpecModelBuilder)).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @Contract(pure=true)
    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 0 : 180;
        }
        return half == Half.TOP ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String m_6055_() {
        return "Panel BlockStates Provider";
    }
}

