/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.PrismSkipPredicate;

@CullTest(value={BlockType.FRAMED_SLOPED_PRISM})
public final class SlopedPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        Direction dir = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (side == dir.m_122424_() || orientation.m_122434_() == dir.m_122434_() || side != orientation) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_SLOPED_PRISM -> SlopedPrismSkipPredicate.testAgainstSlopedPrism(cmpDir, adjState, side);
                case BlockType.FRAMED_PRISM -> SlopedPrismSkipPredicate.testAgainstPrism(cmpDir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_PRISM})
    private static boolean testAgainstSlopedPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.m_61143_(PropertyHolder.FACING_DIR));
        return SlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(SlopedPrismSkipPredicate.getTriDir(adjCmpDir, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PRISM})
    private static boolean testAgainstPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.m_61143_(PropertyHolder.FACING_AXIS));
        return SlopedPrismSkipPredicate.getTriDir(cmpDir, side).isEqualTo(PrismSkipPredicate.getTriDir(adjDirAxis, side.m_122424_()));
    }

    public static HalfDir getTriDir(CompoundDirection cmpDir, Direction side) {
        Direction dir = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (dir.m_122434_() != orientation.m_122434_() && side == orientation) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

