/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedLargeDoubleCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.blockentity.doubled.FramedSmallDoubleCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDoubleCornerSlopePanelWallBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleCornerSlopePanelWallBlock(BlockType blockType) {
        super(blockType);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.getBlockType() == BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> new FramedSmallDoubleCornerSlopePanelWallBlockEntity(pos, state);
            case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> new FramedLargeDoubleCornerSlopePanelWallBlockEntity(pos, state);
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        HorizontalRotation rot;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation backRot = rot.rotate((rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            default -> throw new IllegalArgumentException("Invalid type for this block: " + this.getBlockType());
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                if (rot == HorizontalRotation.UP || rot == HorizontalRotation.RIGHT) {
                    yield DoubleBlockTopInteractionMode.EITHER;
                }
                yield DoubleBlockTopInteractionMode.FIRST;
            }
            case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                if (rot == HorizontalRotation.DOWN || rot == HorizontalRotation.LEFT) {
                    yield DoubleBlockTopInteractionMode.EITHER;
                }
                yield DoubleBlockTopInteractionMode.FIRST;
            }
            default -> throw new IllegalArgumentException("Invalid type for this block: " + this.getBlockType());
        };
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == rotDir && edge == perpRotDir || side == perpRotDir && edge == rotDir) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == dir && (edge == rotDir.m_122424_() || edge == perpRotDir.m_122424_())) {
                    yield CamoGetter.FIRST;
                }
                if (side == dir.m_122424_() && (edge == rotDir.m_122424_() || edge == perpRotDir.m_122424_())) {
                    yield CamoGetter.SECOND;
                }
                if (side == rotDir.m_122424_() || side == perpRotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                if (side == rotDir && edge == perpRotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                if (side == perpRotDir && edge == rotDir.m_122424_()) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> SolidityCheck.NONE;
            case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == rot.withFacing(dir).m_122424_() || side == perpRotDir.m_122424_()) {
                    yield SolidityCheck.FIRST;
                }
                yield SolidityCheck.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    public static ShapeProvider generateSmallShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            CommonShapes.DirBoolKey key = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP -> new CommonShapes.DirBoolKey(dir.m_122428_(), true);
                case HorizontalRotation.DOWN -> new CommonShapes.DirBoolKey(dir.m_122427_(), false);
                case HorizontalRotation.RIGHT -> new CommonShapes.DirBoolKey(dir.m_122427_(), true);
                case HorizontalRotation.LEFT -> new CommonShapes.DirBoolKey(dir.m_122428_(), false);
            };
            builder.put((Object)state, (Object)CommonShapes.SLAB_EDGE.get(key));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = Shapes.m_83148_((VoxelShape)rot.getCornerShape(), (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82687_);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

