/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeedge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IComplexSlopeSource;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeEdgeBlock
extends FramedBlock
implements IComplexSlopeSource {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.25, (double)8.0), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)0.25, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)7.75, (double)4.0), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)7.75, (double)0.0, (double)16.0, (double)8.0, (double)0.25));
        map.put(new ShapeKey(SlopeType.BOTTOM, false), shapeBottom);
        map.put(new ShapeKey(SlopeType.BOTTOM, true), shapeBottom.m_83216_(0.0, 0.5, 0.5));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)15.75, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.75, (double)7.75), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)8.25, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)8.25, (double)0.25));
        map.put(new ShapeKey(SlopeType.TOP, false), shapeTop);
        map.put(new ShapeKey(SlopeType.TOP, true), shapeTop.m_83216_(0.0, -0.5, 0.5));
        VoxelShape shapeHorizontal = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)16.0, (double)8.0), FramedSlopeEdgeBlock.m_49796_((double)0.25, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopeEdgeBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)7.75, (double)16.0, (double)4.0), FramedSlopeEdgeBlock.m_49796_((double)7.75, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)0.25));
        map.put(new ShapeKey(SlopeType.HORIZONTAL, false), shapeHorizontal);
        map.put(new ShapeKey(SlopeType.HORIZONTAL, true), shapeHorizontal.m_83216_(0.5, 0.0, 0.5));
    });

    public FramedSlopeEdgeBlock() {
        super(BlockType.FRAMED_SLOPE_EDGE);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.ALT_TYPE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, PropertyHolder.ALT_TYPE, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.m_122424_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public boolean isHorizontalSlope(BlockState state) {
        return state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] shapes = new VoxelShape[24];
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(new ShapeKey(type, false)), Direction.NORTH, shapes, type, (dir, keyType) -> FramedSlopeEdgeBlock.makeShapeIndex(dir, keyType, false));
            ShapeUtils.makeHorizontalRotations(SHAPES.get(new ShapeKey(type, true)), Direction.NORTH, shapes, type, (dir, keyType) -> FramedSlopeEdgeBlock.makeShapeIndex(dir, keyType, true));
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            SlopeType type;
            type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
            Direction dir2 = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean altType = (Boolean)state.m_61143_((Property)PropertyHolder.ALT_TYPE);
            builder.put((Object)state, (Object)shapes[FramedSlopeEdgeBlock.makeShapeIndex(dir2, type, altType)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static int makeShapeIndex(Direction dir, SlopeType type, boolean altType) {
        return type.ordinal() << 3 | dir.m_122416_() << 1 | (altType ? 1 : 0);
    }

    public record ShapeKey(SlopeType type, boolean altType) {
    }
}

