/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedSlabBlock
extends FramedBlock {
    public FramedSlabBlock() {
        super(BlockType.FRAMED_SLAB);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTop()).withWater()).build();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ((Block)FBContent.BLOCK_FRAMED_SLAB.get()).m_5456_()) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            Direction face = hit.m_82434_();
            if (face == Direction.UP && !top || face == Direction.DOWN && top) {
                if (!level.m_5776_()) {
                    Utils.wrapInStateCopy((LevelAccessor)level, pos, player, stack, top, true, () -> level.m_46597_(pos, ((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLAB.get()).m_49966_()));
                    SoundType sound = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49962_(((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_());
                    level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            builder.put((Object)state, (Object)CommonShapes.SLAB.get((Boolean)state.m_61143_((Property)FramedProperties.TOP)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

