/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedSlopedPrismBlock
extends FramedBlock {
    public FramedSlopedPrismBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.NORTH_UP))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.FACING_DIR, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this, this.getBlockType());
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, Block block, IBlockType blockType) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, context).withCustom((state, modCtx) -> {
            Direction orientation;
            Direction face = modCtx.m_43719_();
            if (Utils.isY(face)) {
                orientation = modCtx.m_8125_();
                if (blockType == BlockType.FRAMED_INNER_SLOPED_PRISM || blockType == BlockType.FRAMED_DOUBLE_SLOPED_PRISM) {
                    orientation = orientation.m_122424_();
                }
            } else {
                Vec3 subHit = Utils.fraction(modCtx.m_43720_());
                double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
                double y = subHit.m_7098_() - 0.5;
                orientation = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? (Utils.isX(face) ? (xz < 0.0 ? Direction.SOUTH : Direction.NORTH) : (xz < 0.0 ? Direction.EAST : Direction.WEST)) : (y < 0.0 ? Direction.UP : Direction.DOWN);
            }
            return (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.of(face, orientation)));
        })).withYSlope(Utils.isY(context.m_43719_()))).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_204117_(Utils.WRENCH)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.rotate(rot)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.mirror(mirror)));
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0));
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape[] shapes = new VoxelShape[CompoundDirection.COUNT];
        for (CompoundDirection cmpDir : CompoundDirection.values()) {
            VoxelShape shape;
            Direction facing = cmpDir.direction();
            Direction orientation = cmpDir.orientation();
            if (Utils.isY(facing)) {
                shapes[cmpDir.ordinal()] = ShapeUtils.rotateShape(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop);
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeLeft;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            shapes[cmpDir.ordinal()] = ShapeUtils.rotateShape(Direction.NORTH, facing, shape);
        }
        for (BlockState state : states) {
            CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
            builder.put((Object)state, (Object)shapes[cmpDir.ordinal()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)15.5));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.0, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)15.5));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)16.0));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.5, (double)15.5, (double)15.5, (double)16.0));
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)16.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)16.0));
        VoxelShape[] shapes = new VoxelShape[CompoundDirection.COUNT];
        for (CompoundDirection cmpDir : CompoundDirection.values()) {
            VoxelShape shape;
            Direction facing = cmpDir.direction();
            Direction orientation = cmpDir.orientation();
            if (Utils.isY(facing)) {
                shapes[cmpDir.ordinal()] = ShapeUtils.rotateShape(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop);
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeRight;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeLeft;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            shapes[cmpDir.ordinal()] = ShapeUtils.rotateShape(Direction.NORTH, facing, shape);
        }
        for (BlockState state : states) {
            CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
            builder.put((Object)state, (Object)shapes[cmpDir.ordinal()]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

