/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlock
extends FramedBlock {
    private static final LoadingCache<Integer, VoxelShape> SHAPE_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new ShapeLoader());

    public FramedCollapsibleBlock(BlockType blockType) {
        super(blockType, IFramedBlock.createProperties(BlockType.FRAMED_COLLAPSIBLE_BLOCK).m_60988_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.ROTATE_SPLIT_LINE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.NULLABLE_FACE, BlockStateProperties.f_61362_, PropertyHolder.ROTATE_SPLIT_LINE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_204117_(Utils.WRENCH)) {
            boolean rotSplitLine = (Boolean)state.m_61143_((Property)PropertyHolder.ROTATE_SPLIT_LINE);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)PropertyHolder.ROTATE_SPLIT_LINE, (Comparable)Boolean.valueOf(!rotSplitLine)));
            return true;
        }
        if (heldItem.m_41720_() == FBContent.ITEM_FRAMED_HAMMER.get() && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (!level.m_5776_()) {
                be.handleDeform(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockEntity blockEntity;
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        NullableDirection face = (NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE));
        if (face != NullableDirection.NONE && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            int offsets = be.getPackedOffsets();
            return (VoxelShape)SHAPE_CACHE.getUnchecked((Object)(offsets |= face.toDirection().m_122411_() << 20));
        }
        return Shapes.m_83144_();
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_() && stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag") && (blockEntity = level.m_7702_(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            Direction collapseFace = be.getCollapsedFace();
            if (((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection() != collapseFace) {
                level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(collapseFace))));
            }
        }
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        NullableDirection face = (NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE));
        return face == NullableDirection.NONE || Utils.isY(face.toDirection());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedCollapsibleBlockEntity(pos, state);
    }

    private static class ShapeLoader
    extends CacheLoader<Integer, VoxelShape> {
        private ShapeLoader() {
        }

        public VoxelShape load(Integer packedData) {
            Direction face = Direction.m_122376_((int)(packedData >> 20));
            byte[] offsets = FramedCollapsibleBlockEntity.unpackOffsets(packedData & 0xFFFFF);
            boolean positive = Utils.isPositive(face);
            boolean flipX = face == Direction.NORTH || face == Direction.EAST;
            boolean flipZ = face != Direction.UP;
            VoxelShape result = Shapes.m_83040_();
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    double x0 = flipX ? 1.0 - (double)x / 4.0 : (double)x / 4.0;
                    double x1 = flipX ? 1.0 - (double)(x + 1) / 4.0 : (double)(x + 1) / 4.0;
                    double z0 = flipZ ? 1.0 - (double)z / 4.0 : (double)z / 4.0;
                    double z1 = flipZ ? 1.0 - (double)(z + 1) / 4.0 : (double)(z + 1) / 4.0;
                    double y0 = Mth.m_14012_((double)x0, (double)z0, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y1 = Mth.m_14012_((double)x1, (double)z1, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y = positive ? Math.max(16.0 - Math.min(y0, y1), (double)2.0E-5f) : Math.min(Math.min(y0, y1), 15.999980000000505);
                    VoxelShape shape = switch (face) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.NORTH -> Block.m_49796_((double)(x * 4), (double)(z * 4), (double)y, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)16.0);
                        case Direction.EAST -> Block.m_49796_((double)0.0, (double)(z * 4), (double)(x * 4), (double)y, (double)((z + 1) * 4), (double)((x + 1) * 4));
                        case Direction.SOUTH -> Block.m_49796_((double)(x * 4), (double)(z * 4), (double)0.0, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)y);
                        case Direction.WEST -> Block.m_49796_((double)y, (double)(z * 4), (double)(x * 4), (double)16.0, (double)((z + 1) * 4), (double)((x + 1) * 4));
                        case Direction.UP -> Block.m_49796_((double)(x * 4), (double)0.0, (double)(z * 4), (double)((x + 1) * 4), (double)y, (double)((z + 1) * 4));
                        case Direction.DOWN -> Block.m_49796_((double)(x * 4), (double)y, (double)(z * 4), (double)((x + 1) * 4), (double)16.0, (double)((z + 1) * 4));
                    };
                    result = ShapeUtils.orUnoptimized(result, shape);
                }
            }
            return result.m_83296_();
        }
    }
}

