/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.loader.overlay;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;

final class OverlayModel
extends BakedModelWrapper<BakedModel> {
    private final List<BakedQuad> unculledQuads;
    private final Map<Direction, List<BakedQuad>> culledQuads;

    public OverlayModel(BakedModel model, Vector3f offset, Vector3f scale) {
        super(model);
        RandomSource random = RandomSource.m_216327_();
        this.unculledQuads = OverlayModel.makeUnculledQuads(model, offset, scale, random);
        this.culledQuads = OverlayModel.makeCulledQuads(model, offset, scale, random);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return side == null ? this.unculledQuads : this.culledQuads.get(side);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        return side == null ? this.unculledQuads : this.culledQuads.get(side);
    }

    private static List<BakedQuad> makeUnculledQuads(BakedModel model, Vector3f offset, Vector3f scale, RandomSource random) {
        return OverlayModel.untranslateQuads(model.getQuads(null, null, random, ModelData.EMPTY, null), offset, scale);
    }

    private static Map<Direction, List<BakedQuad>> makeCulledQuads(BakedModel model, Vector3f offset, Vector3f scale, RandomSource random) {
        EnumMap<Direction, List<BakedQuad>> quadMap = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction side : Direction.values()) {
            List quads = model.getQuads(null, side, random, ModelData.EMPTY, null);
            quadMap.put(side, OverlayModel.untranslateQuads(quads, offset, scale));
        }
        return quadMap;
    }

    private static List<BakedQuad> untranslateQuads(List<BakedQuad> quads, Vector3f offset, Vector3f scale) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            QuadModifier.geometry(quad).apply(Modifiers.offset(Direction.WEST, offset.x() * (1.0f / scale.x()))).apply(Modifiers.offset(Direction.DOWN, offset.y() * (1.0f / scale.y()))).apply(Modifiers.offset(Direction.NORTH, offset.z() * (1.0f / scale.z()))).export(newQuads);
        }
        return newQuads;
    }
}

