/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;

public final class ShapeUtils {
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
    private static final int[] DIR_ROT_X_2D_DATA = (int[])Util.m_137469_((Object)new int[6], arr -> {
        arr[Direction.DOWN.ordinal()] = 2;
        arr[Direction.UP.ordinal()] = 0;
        arr[Direction.NORTH.ordinal()] = 3;
        arr[Direction.SOUTH.ordinal()] = 1;
        arr[Direction.WEST.ordinal()] = -1;
        arr[Direction.EAST.ordinal()] = -1;
    });
    private static final int[] DIR_ROT_Z_2D_DATA = (int[])Util.m_137469_((Object)new int[6], arr -> {
        arr[Direction.DOWN.ordinal()] = 2;
        arr[Direction.UP.ordinal()] = 0;
        arr[Direction.NORTH.ordinal()] = -1;
        arr[Direction.SOUTH.ordinal()] = -1;
        arr[Direction.WEST.ordinal()] = 3;
        arr[Direction.EAST.ordinal()] = 1;
    });

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82695_);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape or(VoxelShape first, VoxelShape second) {
        return ShapeUtils.orUnoptimized(first, second).m_83296_();
    }

    public static VoxelShape or(VoxelShape first, VoxelShape ... others) {
        return ShapeUtils.orUnoptimized(first, others).m_83296_();
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82689_);
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.andUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape and(VoxelShape first, VoxelShape second) {
        return ShapeUtils.andUnoptimized(first, second).m_83296_();
    }

    public static VoxelShape and(VoxelShape first, VoxelShape ... others) {
        return ShapeUtils.andUnoptimized(first, others).m_83296_();
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimized(from, to, shape).m_83296_();
    }

    public static VoxelShape rotateShapeUnoptimized(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isY(from) || Utils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShapeAroundX(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimizedAroundX(from, to, shape).m_83296_();
    }

    public static VoxelShape rotateShapeUnoptimizedAroundX(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isX(from) || Utils.isX(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (DIR_ROT_X_2D_DATA[to.ordinal()] - DIR_ROT_X_2D_DATA[from.ordinal()] + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(box.f_82288_, 1.0 - box.f_82293_, box.f_82289_, box.f_82291_, 1.0 - box.f_82290_, box.f_82292_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShapeAroundZ(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimizedAroundZ(from, to, shape).m_83296_();
    }

    public static VoxelShape rotateShapeUnoptimizedAroundZ(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isZ(from) || Utils.isZ(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (DIR_ROT_Z_2D_DATA[to.ordinal()] - DIR_ROT_Z_2D_DATA[from.ordinal()] + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(box.f_82289_, 1.0 - box.f_82291_, box.f_82290_, box.f_82292_, 1.0 - box.f_82288_, box.f_82293_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, VoxelShape[] out, int baseOffset) {
        if (Utils.isY(srcDir)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        for (int i = 0; i < 4; ++i) {
            boolean baseShape = i == srcDir.m_122416_();
            out[baseOffset + i] = baseShape ? shape : Shapes.m_83040_();
        }
        List sourceBoxes = shape.m_83299_();
        for (AABB box : sourceBoxes) {
            for (int i = 1; i < 4; ++i) {
                int idx = baseOffset + (srcDir.m_122416_() + i) % 4;
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
                out[idx] = ShapeUtils.orUnoptimized(out[idx], Shapes.m_83064_((AABB)box));
            }
        }
        for (int i = 0; i < 4; ++i) {
            out[baseOffset + i] = out[baseOffset + i].m_83296_();
        }
    }

    public static VoxelShape[] makeHorizontalRotations(VoxelShape shape, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        return shapes;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<Direction, VoxelShape> targetMap) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(dir, shapes[dir.m_122416_()]);
        }
    }

    public static <V, T> void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<T, VoxelShape> targetMap, V staticKeyParam, ArbKeyGenerator<V, T> keyGen) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, staticKeyParam), shapes[dir.m_122416_()]);
        }
    }

    public static <V> void makeHorizontalRotations(VoxelShape shape, Direction srcDir, VoxelShape[] shapes, V staticKeyParam, ArbIndexGenerator<V> keyGen) {
        VoxelShape[] preShapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, preShapes, 0);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            shapes[keyGen.makeKey((Direction)dir, staticKeyParam)] = preShapes[dir.m_122416_()];
        }
    }

    public static VoxelShape[] makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, shapes, 4);
        return shapes;
    }

    public static <T> void makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir, Map<T, VoxelShape> targetMap, FlagKeyGenerator<T> keyGen) {
        VoxelShape[] shapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, shapes, 4);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, false), shapes[dir.m_122416_()]);
            targetMap.put(keyGen.makeKey(dir, true), shapes[dir.m_122416_() + 4]);
        }
    }

    public static void makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir, VoxelShape[] shapes, FlagIndexGenerator keyGen) {
        VoxelShape[] preShapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, preShapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, preShapes, 4);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            shapes[keyGen.makeKey((Direction)dir, (boolean)false)] = preShapes[dir.m_122416_()];
            shapes[keyGen.makeKey((Direction)dir, (boolean)true)] = preShapes[dir.m_122416_() + 4];
        }
    }

    private ShapeUtils() {
    }

    public static interface ArbKeyGenerator<V, T> {
        public T makeKey(Direction var1, V var2);
    }

    public static interface ArbIndexGenerator<V> {
        public int makeKey(Direction var1, V var2);
    }

    public static interface FlagKeyGenerator<T> {
        public T makeKey(Direction var1, boolean var2);
    }

    public static interface FlagIndexGenerator {
        public int makeKey(Direction var1, boolean var2);
    }
}

