/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class CommonShapes {
    public static final ShapeCache<Boolean> SLAB = ShapeCache.createIdentity(map -> {
        map.put(Boolean.FALSE, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
        map.put(Boolean.TRUE, Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    });
    public static final ShapeCache<Direction> PANEL = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });
    public static final ShapeCache<DirBoolKey> SLAB_EDGE = ShapeCache.create(map -> {
        VoxelShape shapeBot = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape shapeTop = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotationsWithFlag(shapeBot, shapeTop, Direction.NORTH, map, DirBoolKey::new);
    });
    public static final ShapeCache<Direction> CORNER_PILLAR = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });
    public static final ShapeCache<DirBoolKey> STRAIGHT_STAIRS = ShapeCache.create(map -> {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
        ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.SOUTH, map, DirBoolKey::new);
    });
    public static final ShapeCache<Direction> STRAIGHT_VERTICAL_STAIRS = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
        ShapeUtils.makeHorizontalRotations(shape, Direction.SOUTH, map);
    });

    private CommonShapes() {
    }

    public record DirBoolKey(Direction dir, boolean top) {
    }
}

