/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Optional;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MilkJarBlock
extends BlockKitchen
implements BucketPickup {
    public static final String name = "milk_jar";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "milk_jar");
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)11.2, (double)8.0, (double)11.2);

    public MilkJarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60978_(0.6f), registryName);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LOWERED});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (MilkJarBlock.shouldBlockRenderLowered(world, pos)) {
            return SHAPE.m_83216_(0.0, -0.05, 0.0);
        }
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        MilkJarBlockEntity milkJar = (MilkJarBlockEntity)level.m_7702_(pos);
        if (!heldItem.m_41619_() && milkJar != null) {
            FluidTank milkTank = milkJar.getFluidTank();
            if (heldItem.m_41720_() == Items.f_42455_) {
                if (milkTank.getAmount() <= milkTank.getCapacity() - 1000) {
                    milkTank.fill(Compat.getMilkFluid(), 1000, false);
                    if (!player.m_150110_().f_35937_) {
                        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_41720_() == Items.f_42446_) {
                if (milkTank.getAmount() >= 1000) {
                    if (heldItem.m_41613_() == 1) {
                        milkTank.drain(Compat.getMilkFluid(), 1000, false);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42455_));
                        }
                    } else if (player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42455_))) {
                        milkTank.drain(Compat.getMilkFluid(), 1000, false);
                        if (!player.m_150110_().f_35937_) {
                            heldItem.m_41774_(1);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MilkJarBlockEntity(pos, state);
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MilkJarBlockEntity) {
            MilkJarBlockEntity milkJar = (MilkJarBlockEntity)blockEntity;
            if (((MilkJarBlockEntity)blockEntity).getFluidTank().getAmount() >= 1000) {
                int drained = milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
                return drained >= 1000 ? new ItemStack((ItemLike)Items.f_42455_) : ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }
}

