/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.networking.snyc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.utils.config.config.ConfigHandler;
import pregenerator.common.utils.config.impl.ReloadMode;
import pregenerator.common.utils.config.networking.snyc.SyncPacket;
import pregenerator.common.utils.config.utils.SyncType;

public class BulkSyncPacket
implements IPregenPacket {
    List<SyncPacket> packets = new ObjectArrayList();

    public BulkSyncPacket() {
    }

    public BulkSyncPacket(List<SyncPacket> packets) {
        this.packets = packets;
    }

    public static BulkSyncPacket create(Collection<ConfigHandler> toSync, SyncType type, boolean forceSync) {
        ObjectArrayList result = new ObjectArrayList();
        for (ConfigHandler handler : toSync) {
            SyncPacket packet = SyncPacket.create(handler, type, forceSync);
            if (packet == null) continue;
            result.add(packet);
        }
        return result.isEmpty() ? null : new BulkSyncPacket((List<SyncPacket>)result);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.packets.size());
        for (SyncPacket packet : this.packets) {
            packet.write(buffer);
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            SyncPacket packet = new SyncPacket();
            packet.read(buffer);
            this.packets.add(packet);
        }
    }

    @Override
    public void process(Player player) {
        ReloadMode result = null;
        for (SyncPacket packet : this.packets) {
            result = ReloadMode.or(result, packet.processEntry(player));
        }
        if (result != null) {
            player.m_213846_(result.getMessage());
        }
    }
}

