/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.gui.screen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.config.api.ConfigType;
import pregenerator.common.utils.config.gui.api.BackgroundTexture;
import pregenerator.common.utils.config.gui.api.IModConfig;
import pregenerator.common.utils.config.gui.api.IModConfigs;
import pregenerator.common.utils.config.gui.config.ConfigElement;
import pregenerator.common.utils.config.gui.config.Element;
import pregenerator.common.utils.config.gui.config.IIgnoreSearch;
import pregenerator.common.utils.config.gui.config.ListScreen;
import pregenerator.common.utils.config.gui.screen.ConfigScreen;
import pregenerator.common.utils.config.gui.screen.RequestScreen;
import pregenerator.common.utils.config.gui.screen.SelectFileScreen;
import pregenerator.common.utils.config.gui.widgets.CarbonButton;
import pregenerator.common.utils.config.gui.widgets.CarbonIconButton;
import pregenerator.common.utils.config.gui.widgets.GuiUtils;
import pregenerator.common.utils.config.gui.widgets.Icon;

public class ConfigSelectorScreen
extends ListScreen {
    IModConfigs configs;
    Screen parent;
    Component modName;
    Label toAdd;

    public ConfigSelectorScreen(IModConfigs configs, Screen parent) {
        this(configs, configs.getBackground(), parent);
    }

    public ConfigSelectorScreen(IModConfigs configs, BackgroundTexture.BackgroundHolder customTexture, Screen parent) {
        super((Component)Component.m_237115_((String)"gui.chunk_pregen.config.select_config"), customTexture);
        this.configs = configs;
        this.parent = parent;
        this.modName = Component.m_237113_((String)configs.getModName());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_;
        this.m_142416_((GuiEventListener)new CarbonButton(x - 80, y - 27, 160, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.back"), T -> this.m_7379_()));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.modName, this.f_96543_ / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        this.toAdd = new Label((Component)Component.m_237115_((String)"gui.chunk_pregen.config.configs.local").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        this.addConfigs(ConfigType.CLIENT, false, elements);
        this.addConfigs(ConfigType.SHARED, false, elements);
        this.toAdd = null;
        if (this.f_96541_.f_91073_ != null) {
            if (!this.f_96541_.m_91091_()) {
                if (!this.isInstalledOnServer()) {
                    return;
                }
                if (this.isLanServer()) {
                    return;
                }
                if (!this.f_96541_.f_91074_.m_20310_(4)) {
                    return;
                }
                this.toAdd = new Label((Component)Component.m_237115_((String)"gui.chunk_pregen.config.configs.multiplayer").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                this.addConfigs(ConfigType.SHARED, true, elements);
            } else {
                this.toAdd = new Label((Component)Component.m_237115_((String)"gui.chunk_pregen.config.configs.world").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            }
        } else {
            this.toAdd = new Label((Component)Component.m_237115_((String)"gui.chunk_pregen.config.configs.world").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        }
        this.addConfigs(ConfigType.SERVER, true, elements);
        this.toAdd = null;
    }

    private void addConfigs(ConfigType type, boolean multiplayer, Consumer<Element> elements) {
        this.configs.getConfigInstances(type).forEach(T -> {
            if (this.toAdd != null) {
                elements.accept(this.toAdd);
                this.toAdd = null;
            }
            elements.accept(new DirectConfig((IModConfig)T, this.modName, this, multiplayer));
        });
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private boolean isInstalledOnServer() {
        return NetworkManager.INSTANCE.isInstalledOnServer();
    }

    private boolean isLanServer() {
        ServerData data = this.f_96541_.m_91089_();
        return data != null && data.m_105389_();
    }

    public static class Label
    extends Element
    implements IIgnoreSearch {
        public Label(Component name) {
            super(name);
        }

        @Override
        public boolean shouldIgnoreSearch() {
            return true;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.renderText(graphics, this.name, left, top + 1, width, height, ConfigElement.GuiAlign.CENTER, -1);
        }
    }

    public static class DirectConfig
    extends Element {
        List<GuiEventListener> children = new ObjectArrayList();
        Screen parent;
        IModConfig handler;
        Button button;
        CarbonIconButton reset;
        boolean multi;
        boolean multiplayer;
        ConfigScreen.Navigator nav;
        Component type;
        Component fileName;
        Component baseName;

        public DirectConfig(IModConfig handler, Component baseName, Screen parent, boolean multiplayer) {
            super((Component)Component.m_237113_((String)handler.getFileName()));
            this.nav = new ConfigScreen.Navigator(baseName);
            this.nav.setScreenForLayer(parent);
            this.handler = handler;
            this.baseName = baseName;
            this.parent = parent;
            this.multiplayer = multiplayer;
        }

        @Override
        public void init() {
            this.multi = this.shouldCreatePick();
            if (this.multi) {
                this.button = new CarbonButton(0, 0, 82, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.pick_file"), this::onPick);
                this.children.add((GuiEventListener)this.button);
            } else {
                this.button = new CarbonButton(0, 0, 60, 20, (Component)Component.m_237115_((String)"gui.chunk_pregen.config.modify"), this::onEdit);
                this.reset = new CarbonIconButton(0, 0, 20, 20, Icon.REVERT, (Component)Component.m_237119_(), this::reset).setIconOnly();
                this.reset.f_93623_ = !this.handler.isDefault() && !this.isInWorldConfig();
                this.children.add((GuiEventListener)this.button);
                this.children.add((GuiEventListener)this.reset);
            }
            this.type = Component.m_237115_((String)("gui.chunk_pregen.config.type." + this.handler.getConfigType().name().toLowerCase()));
            this.fileName = Component.m_237113_((String)this.handler.getFileName()).m_130940_(ChatFormatting.GRAY);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.m_252865_(left + width - 82);
            this.button.m_253211_(top + 2);
            this.button.m_88315_(graphics, mouseX, mouseY, partialTicks);
            if (this.reset != null) {
                this.reset.m_252865_(left + width - 20);
                this.reset.m_253211_(top + 2);
                this.reset.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
            GuiUtils.drawScrollingString(graphics, this.font, this.type, left + 5, top, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(graphics, this.font, this.fileName, left + 5, top + 9, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawTextureRegion(graphics, left - 20, top, 22.0f, 22.0f, this.getIcon(), 16.0f, 16.0f);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        private boolean shouldCreatePick() {
            return this.handler.isDynamicConfig() && !this.isInWorldConfig();
        }

        private boolean isInWorldConfig() {
            return this.mc.f_91073_ != null && (this.handler.getConfigType() == ConfigType.SERVER || this.handler.getConfigType() == ConfigType.SHARED && this.multiplayer);
        }

        private Icon getIcon() {
            return (this.multi ? Icon.MULTITYPE_ICON : Icon.TYPE_ICON).get((Object)this.handler.getConfigType());
        }

        private void onPick(Button button) {
            this.mc.m_91152_((Screen)new SelectFileScreen(this.baseName, this.owner.getCustomTexture(), this.parent, this.handler));
        }

        private void reset(CarbonIconButton button) {
            this.handler.restoreDefault();
            this.handler.save();
            this.reset.f_93623_ = !this.handler.isDefault();
        }

        private void onEdit(Button button) {
            if (this.isInWorldConfig() && !this.mc.m_91091_()) {
                this.mc.m_91152_((Screen)new RequestScreen(this.owner.getCustomTexture(), this.nav.add(this.type), this.parent, this.handler));
            } else {
                this.mc.m_91152_((Screen)new ConfigScreen(this.nav.add(this.type), this.handler, this.parent, this.owner.getCustomTexture()));
            }
        }
    }
}

