/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.config.impl.internal.EventHandler;

public class SyncStatePacket
implements IPregenPacket {
    Dist source;

    public SyncStatePacket() {
    }

    public SyncStatePacket(Dist source) {
        this.source = source;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.source.isClient());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.source = buffer.readBoolean() ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    @Override
    public void process(Player player) {
        if (this.source.isDedicatedServer()) {
            NetworkManager.INSTANCE.onPlayerJoined(player, false);
        } else {
            EventHandler.INSTANCE.onServerJoinPacket(player);
        }
    }
}

