/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.networking.packets.MemoryPacket;
import pregenerator.common.networking.packets.OverlayPacket;
import pregenerator.common.networking.packets.ProgressPacket;
import pregenerator.common.networking.packets.RetrogenPacket;
import pregenerator.common.networking.packets.SyncStatePacket;
import pregenerator.common.networking.packets.TaskPacket;
import pregenerator.common.utils.config.networking.carbon.ConfigAnswerPacket;
import pregenerator.common.utils.config.networking.carbon.ConfigRequestPacket;
import pregenerator.common.utils.config.networking.carbon.SaveConfigPacket;
import pregenerator.common.utils.config.networking.snyc.BulkSyncPacket;
import pregenerator.common.utils.config.networking.snyc.SyncPacket;

public class NetworkManager {
    public static final NetworkManager INSTANCE = new NetworkManager();
    SimpleChannel channel;
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chunkpregen", "networking"), () -> "default", T -> true, T -> true);
        this.registerInternalPacket(1, OverlayPacket.Request.class, OverlayPacket.Request::new);
        this.registerInternalPacket(2, OverlayPacket.Answer.class, OverlayPacket.Answer::new);
        this.registerInternalPacket(3, RetrogenPacket.Request.class, RetrogenPacket.Request::new);
        this.registerInternalPacket(4, RetrogenPacket.Answer.class, RetrogenPacket.Answer::new);
        this.registerInternalPacket(5, RetrogenPacket.Change.class, RetrogenPacket.Change::new);
        this.registerInternalPacket(6, RetrogenPacket.Sync.class, RetrogenPacket.Sync::new);
        this.registerInternalPacket(7, MemoryPacket.RequestFree.class, MemoryPacket.RequestFree::new);
        this.registerInternalPacket(8, MemoryPacket.RequestUsed.class, MemoryPacket.RequestUsed::new);
        this.registerInternalPacket(9, MemoryPacket.Answer.class, MemoryPacket.Answer::new);
        this.registerInternalPacket(10, ProgressPacket.Start.class, ProgressPacket.Start::new);
        this.registerInternalPacket(11, ProgressPacket.Update.class, ProgressPacket.Update::new);
        this.registerInternalPacket(12, ProgressPacket.Complete.class, ProgressPacket.Complete::new);
        this.registerInternalPacket(13, ProgressPacket.Cancel.class, ProgressPacket.Cancel::new);
        this.registerInternalPacket(14, TaskPacket.RequestTasks.class, TaskPacket.RequestTasks::new);
        this.registerInternalPacket(15, TaskPacket.AnswerTasks.class, TaskPacket.AnswerTasks::new);
        this.registerInternalPacket(16, TaskPacket.Action.class, TaskPacket.Action::new);
        this.registerInternalPacket(17, TaskPacket.RequestSpeeds.class, TaskPacket.RequestSpeeds::new);
        this.registerInternalPacket(18, TaskPacket.AnswerSpeeds.class, TaskPacket.AnswerSpeeds::new);
        this.registerInternalPacket(19, CommandPacket.Request.class, CommandPacket.Request::new);
        this.registerInternalPacket(20, CommandPacket.Answer.class, CommandPacket.Answer::new);
        this.registerInternalPacket(21, CommandPacket.Action.class, CommandPacket.Action::new);
        this.registerInternalPacket(22, CommandPacket.GenTask.class, CommandPacket.GenTask::new);
        this.registerInternalPacket(23, CommandPacket.DeletionTask.class, CommandPacket.DeletionTask::new);
        this.registerInternalPacket(24, CommandPacket.RequestPerms.class, CommandPacket.RequestPerms::new);
        this.registerInternalPacket(25, CommandPacket.AnswerPerms.class, CommandPacket.AnswerPerms::new);
        this.registerInternalPacket(26, SyncPacket.class, SyncPacket::new);
        this.registerInternalPacket(27, BulkSyncPacket.class, BulkSyncPacket::new);
        this.registerInternalPacket(28, ConfigRequestPacket.class, ConfigRequestPacket::new);
        this.registerInternalPacket(29, ConfigAnswerPacket.class, ConfigAnswerPacket::new);
        this.registerInternalPacket(30, SaveConfigPacket.class, SaveConfigPacket::new);
        this.registerInternalPacket(31, SyncStatePacket.class, SyncStatePacket::new);
    }

    public <T extends IPregenPacket> void registerPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.registerPacket(index, 64, packet, creator);
    }

    private <T extends IPregenPacket> void registerInternalPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.registerPacket(index, 0, packet, creator);
    }

    private <T extends IPregenPacket> void registerPacket(int index, int base, Class<T> packet, Supplier<T> creator) {
        this.channel.registerMessage(index + base, packet, this::writePacket, K -> this.readPacket((FriendlyByteBuf)K, creator), this::handlePacket);
    }

    protected void writePacket(IPregenPacket packet, FriendlyByteBuf buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends IPregenPacket> T readPacket(FriendlyByteBuf buffer, Supplier<T> values) {
        try {
            IPregenPacket packet = (IPregenPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(IPregenPacket packet, Supplier<NetworkEvent.Context> provider) {
        try {
            NetworkEvent.Context context = provider.get();
            Player player = this.getPlayer(context);
            if (packet.requiresMainThread()) {
                context.enqueueWork(() -> packet.process(player));
            } else {
                packet.process(player);
            }
            context.setPacketHandled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    protected Player getPlayer(NetworkEvent.Context cont) {
        ServerPlayer entity = cont.getSender();
        return entity != null ? entity : this.getClientPlayer();
    }

    public void onPlayerJoined(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.m_20148_());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.m_20148_());
        } else {
            this.serverInstalled = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public boolean isInstalled(Player player) {
        return player instanceof ServerPlayer ? this.isInstalledOnClient((ServerPlayer)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(ServerPlayer player) {
        return this.clientInstalledPlayers.contains(player.m_20148_());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToServer(IPregenPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public void sendToAllPlayers(IPregenPacket packet) {
        this.channel.send(PacketDistributor.NMLIST.with(this::getAllPlayers), (Object)packet);
    }

    private List<Connection> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player.f_8906_.f_9742_);
        }
        return players;
    }

    public void sendToPlayer(IPregenPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
    }
}

