/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SeedManager {
    public static final SeedManager INSTANCE = new SeedManager();
    boolean loaded = false;
    Object2LongMap<ResourceKey<Level>> seeds = new Object2LongOpenHashMap();
    Object2LongMap<ResourceKey<Level>> structureSeeds = new Object2LongOpenHashMap();

    public void onServerStopping(ServerStoppingEvent event) {
        this.loaded = false;
        this.seeds.clear();
        this.structureSeeds.clear();
    }

    public long getSeed(ResourceKey<Level> level, long originalSeed) {
        this.loadSeeds();
        if (this.seeds.containsKey(level)) {
            return BiomeManager.m_47877_((long)this.seeds.getLong(level));
        }
        return originalSeed;
    }

    public long getStructureSeed(ResourceKey<Level> level, long originalSeed) {
        this.loadSeeds();
        return this.structureSeeds.getOrDefault(level, originalSeed);
    }

    public void mergeSeeds(Map<ResourceKey<Level>, String> seeds, Path path) {
        for (Map.Entry<ResourceKey<Level>, String> entry : seeds.entrySet()) {
            long seed = SeedManager.makeSeed(entry.getValue());
            this.seeds.put(entry.getKey(), seed);
            this.structureSeeds.put(entry.getKey(), seed);
        }
        this.saveSeeds(path);
        this.seeds.clear();
        this.structureSeeds.clear();
        this.loaded = false;
    }

    private void loadSeeds() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Path path = this.getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject data;
                JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (JsonElement el : obj.getAsJsonArray("level_seeds")) {
                    data = el.getAsJsonObject();
                    this.seeds.put((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)data.get("dim").getAsString())), data.get("seed").getAsLong());
                }
                for (JsonElement el : obj.getAsJsonArray("structure_seeds")) {
                    data = el.getAsJsonObject();
                    this.structureSeeds.put((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)data.get("dim").getAsString())), data.get("seed").getAsLong());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            WorldOptions settings = server.m_129910_().m_246337_();
            long seed = settings.m_245499_();
            for (ResourceKey key : server.m_206579_().m_6632_(Registries.f_256858_).map(Registry::m_214010_).orElse(Collections.emptySet())) {
                this.seeds.putIfAbsent((Object)key, seed);
                this.structureSeeds.putIfAbsent((Object)key, seed);
            }
            this.saveSeeds(this.getPath());
        }
    }

    private void saveSeeds(Path path) {
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            JsonObject obj;
            JsonArray seedObj = new JsonArray();
            JsonArray structureSeedObj = new JsonArray();
            for (Object2LongMap.Entry entry : this.seeds.object2LongEntrySet()) {
                obj = new JsonObject();
                obj.addProperty("dim", ((ResourceKey)entry.getKey()).m_135782_().toString());
                obj.addProperty("seed", (Number)entry.getLongValue());
                seedObj.add((JsonElement)obj);
            }
            for (Object2LongMap.Entry entry : this.structureSeeds.object2LongEntrySet()) {
                obj = new JsonObject();
                obj.addProperty("dim", ((ResourceKey)entry.getKey()).m_135782_().toString());
                obj.addProperty("seed", (Number)entry.getLongValue());
                structureSeedObj.add((JsonElement)obj);
            }
            JsonObject obj2 = new JsonObject();
            obj2.add("level_seeds", (JsonElement)seedObj);
            obj2.add("structure_seeds", (JsonElement)structureSeedObj);
            writer.setIndent("\t");
            Streams.write((JsonElement)obj2, (JsonWriter)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Path getPath() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("serverconfig")).resolve("pregen_seeds.json");
    }

    public static long makeSeed(String input) {
        try {
            return !StringUtil.m_14408_((String)input) ? Long.parseLong(input) : 0L;
        }
        catch (NumberFormatException e) {
            return input.hashCode();
        }
    }
}

