/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;
import pregenerator.base.mixins.common.server.MinecraftServerMixin;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;

public class DimensionManager {
    public static final DimensionManager INSTANCE = new DimensionManager();

    public void disableDimension(ResourceKey<Level> dimension, Consumer<Component> listener) {
        if (this.canUnloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension, listener)) {
            MutableComponent dim = TextUtil.dimension(dimension);
            if (!DimensionRegistry.getRegistry().addDimension(dimension.m_135782_())) {
                listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.already_unloaded", dim).m_130940_(ChatFormatting.RED));
                return;
            }
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.unloading", dim));
            this.unloadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.unloaded", dim));
        }
    }

    public void enableDimension(ResourceKey<Level> dimension, Consumer<Component> listener) {
        if (DimensionRegistry.getRegistry().removeDimension(dimension.m_135782_())) {
            MutableComponent dim = TextUtil.dimension(dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.loading", dim));
            this.loadDimension(ServerLifecycleHooks.getCurrentServer(), dimension);
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.loaded", dim));
            return;
        }
        listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.already_loaded", TextUtil.dimension(dimension)).m_130940_(ChatFormatting.RED));
    }

    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        for (ResourceLocation dim : DimensionRegistry.getDims()) {
            this.syncTime(server);
            this.unloadDimension(server, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim));
        }
    }

    private boolean canUnloadDimension(MinecraftServer server, ResourceKey<Level> world, Consumer<Component> listener) {
        if (Level.f_46428_.m_135782_().equals((Object)world.m_135782_())) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.overworld"));
            return false;
        }
        ServerLevel serverWorld = server.m_129880_(world);
        if (serverWorld == null) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.not_exist", TextUtil.dimension(world)).m_130940_(ChatFormatting.RED));
            return false;
        }
        if (serverWorld.m_6907_().size() > 0) {
            listener.accept((Component)TextUtil.translate("command.chunk_pregen.dimension.error.players"));
            return false;
        }
        return true;
    }

    private void loadDimension(MinecraftServer server, ResourceKey<Level> world) {
        WorldData config = server.m_129910_();
        WorldOptions settings = config.m_246337_();
        LevelStem dim = (LevelStem)server.m_206579_().m_175515_(Registries.f_256862_).m_6246_(ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)world.m_135782_()));
        ServerLevel serverWorld = new ServerLevel(server, (Executor)Util.m_183991_(), this.getLevelSave(server), (ServerLevelData)new DerivedLevelData(config, config.m_5996_()), world, dim, this.getStatusListener(server), config.m_7513_(), BiomeManager.m_47877_((long)settings.m_245499_()), (List)ImmutableList.of(), true, server.m_129783_().m_288231_());
        server.m_129880_(Level.f_46428_).m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(serverWorld.m_6857_()));
        server.forgeGetWorldMap().put(world, serverWorld);
        server.markWorldsDirty();
    }

    private void unloadDimension(MinecraftServer server, ResourceKey<Level> key) {
        ServerLevel world = server.m_129880_(key);
        if (world == null) {
            return;
        }
        world.m_8643_(null, true, false);
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)world));
        try {
            world.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server.forgeGetWorldMap().remove(key);
        server.markWorldsDirty();
    }

    private LevelStorageSource.LevelStorageAccess getLevelSave(MinecraftServer server) {
        return ((MinecraftServerMixin)server).getCurrentSave();
    }

    private ChunkProgressListener getStatusListener(MinecraftServer server) {
        return ((ChunkManagerMixin)server.m_129880_((ResourceKey)Level.f_46428_).m_7726_().f_8325_).getStatusListener();
    }

    public void syncTime(MinecraftServer server) {
        ((MinecraftServerMixin)server).setServerTime(Util.m_137550_() + 100L);
    }

    public static class DimensionRegistry
    extends SavedData {
        ObjectSet<ResourceLocation> locations = new ObjectLinkedOpenHashSet();

        public static DimensionRegistry getRegistry() {
            return (DimensionRegistry)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(DimensionRegistry::loadData, DimensionRegistry::new, "pregen_dimensions");
        }

        public static DimensionRegistry loadData(CompoundTag data) {
            DimensionRegistry registry = new DimensionRegistry();
            registry.load(data);
            return registry;
        }

        public void load(CompoundTag nbt) {
            this.locations.clear();
            ListTag list = nbt.m_128437_("dimensions", 8);
            int i = 0;
            while (i < list.size()) {
                this.locations.add((Object)new ResourceLocation(list.m_128778_(i++)));
            }
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            ListTag list = new ListTag();
            for (ResourceLocation location : this.locations) {
                list.add((Object)StringTag.m_129297_((String)location.toString()));
            }
            compound.m_128365_("dimensions", (Tag)list);
            return compound;
        }

        public boolean addDimension(ResourceLocation location) {
            if (!Level.f_46428_.m_135782_().equals((Object)location) && this.locations.add((Object)location)) {
                this.m_77762_();
                return true;
            }
            return false;
        }

        public boolean removeDimension(ResourceLocation location) {
            if (this.locations.remove((Object)location)) {
                this.m_77762_();
                return true;
            }
            return false;
        }

        public static Iterable<ResourceLocation> getDims() {
            return () -> ObjectIterators.unmodifiable((ObjectIterator)DimensionRegistry.getRegistry().locations.iterator());
        }
    }
}

