/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import pregenerator.ChunkPregenerator;

public class RetrogenManager {
    public static final RetrogenManager INSTANCE = new RetrogenManager();
    Set<ResourceLocation> activeFeatures = new ObjectLinkedOpenHashSet();

    public Set<ResourceLocation> getInactiveFeatures(RegistryAccess access) {
        ObjectLinkedOpenHashSet locations = new ObjectLinkedOpenHashSet(this.getAllFeatures(access));
        locations.removeAll(this.activeFeatures);
        return locations;
    }

    public List<ResourceLocation> getAllFeatures(RegistryAccess access) {
        return new ObjectArrayList((Collection)access.m_6632_(Registries.f_256988_).map(Registry::m_6566_).orElse(Collections.emptySet()));
    }

    public Set<ResourceLocation> getActiveFeatures() {
        return new ObjectLinkedOpenHashSet(this.activeFeatures);
    }

    public Map<String, Map<String, List<ResourceLocation>>> getAllMappedFeatures(RegistryAccess access) {
        Registry registry = access.m_175515_(Registries.f_256988_);
        Registry featureRegistry = access.m_175515_(Registries.f_256833_);
        Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
        ObjectArrayList sorted = new ObjectArrayList((Collection)registry.m_6579_());
        sorted.sort(Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : sorted) {
            Map map = result.computeIfAbsent(((ResourceKey)entry.getKey()).m_135782_().m_135827_(), T -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
            map.computeIfAbsent(featureRegistry.m_7981_((Object)((ConfiguredFeature)((PlacedFeature)entry.getValue()).f_191775_().m_203334_()).f_65377_()).m_135815_(), T -> new ObjectArrayList()).add(((ResourceKey)entry.getKey()).m_135782_());
        }
        for (Map.Entry entry : result.entrySet()) {
            Object2ObjectLinkedOpenHashMap newValue = new Object2ObjectLinkedOpenHashMap();
            newValue.putAll((Map)entry.getValue());
            entry.setValue(newValue);
        }
        return result;
    }

    public void enableFeature(ResourceLocation location) {
        this.activeFeatures.add(location);
    }

    public void disableFeature(ResourceLocation location) {
        this.activeFeatures.remove(location);
    }

    public boolean isActive(ResourceLocation location) {
        return this.activeFeatures.contains(location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onSyncPacket(Set<ResourceLocation> active) {
        this.activeFeatures.clear();
        this.activeFeatures.addAll(active);
    }

    public void retrogenChunks(LevelChunk chunk, List<ChunkAccess> chunks) {
        if (this.activeFeatures.isEmpty()) {
            return;
        }
        BlockPos pos = SectionPos.m_123196_((ChunkPos)chunk.m_7697_(), (int)chunk.m_62953_().m_151560_()).m_123249_();
        try {
            ServerLevel world = (ServerLevel)chunk.m_62953_();
            WorldgenRandom sharedseedrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            long i1 = sharedseedrandom.m_64690_(world.m_7328_(), pos.m_123341_(), pos.m_123343_());
            ChunkGenerator generator = world.m_7726_().m_8481_();
            WorldGenRegion region = new WorldGenRegion(world, chunks, ChunkStatus.f_62326_, 8);
            Biome biome = (Biome)chunk.m_203495_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).m_203334_();
            for (GenerationStep.Decoration generationstage$decoration : GenerationStep.Decoration.values()) {
                try {
                    this.decorate(biome, generationstage$decoration, generator, (WorldGenLevel)region, i1, sharedseedrandom, pos);
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Biome decoration");
                    crashreport.m_127514_("Generation").m_128159_("CenterX", (Object)chunk.m_7697_().f_45578_).m_128159_("CenterZ", (Object)chunk.m_7697_().f_45579_).m_128159_("Step", (Object)generationstage$decoration).m_128159_("Seed", (Object)i1).m_128159_("Biome", (Object)ForgeRegistries.BIOMES.getKey((Object)biome)).m_128159_("Chunk Pregenerator Gen", (Object)true);
                    throw new ReportedException(crashreport);
                }
            }
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.catching((Throwable)e);
        }
    }

    private void decorate(Biome biome, GenerationStep.Decoration stage, ChunkGenerator chunkGenerator, WorldGenLevel worldIn, long seed, WorldgenRandom random, BlockPos pos) {
        Registry registry = worldIn.m_7654_().m_206579_().m_175515_(Registries.f_256988_);
        int i = 0;
        for (Holder feature : (HolderSet)biome.m_47536_().m_47818_().get(stage.ordinal())) {
            PlacedFeature configuredfeature = (PlacedFeature)feature.m_203334_();
            if (!this.activeFeatures.contains(registry.m_7981_((Object)configuredfeature))) {
                ++i;
                continue;
            }
            random.m_190064_(seed, i, stage.ordinal());
            try {
                configuredfeature.m_226377_(worldIn, chunkGenerator, (RandomSource)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Feature placement");
                crashreport.m_127514_("Feature").m_128159_("Id", (Object)registry.m_7981_((Object)configuredfeature));
                throw new ReportedException(crashreport);
            }
            ++i;
        }
    }
}

